/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project;

import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.ControlPar;
import java.io.File;

public class CommonConst {
    private static String projectName;
    private static String suiteName;
    private static String applicationName;
    private static String applicationShortName;
    private static String applicationVersion;
    private static String applicationCopyright;
    private static String applicationFullName;
    private static String workingDir;
    private static String userDir;
    private static String shareResourcesDir;
    private static String configFileDir;
    private static String emergencyLogFileFolder;
    private static String tempDir;
    private static boolean writeAccessToShareDir;
    private static String fileTimeFormat;
    private static String dateFormatOneDayPattern;
    private static String dateFormatIndividualPattern;
    private static String dateFormatLookPattern;
    private static final Object syncTempDirCreation;
    private static volatile transient boolean tempDirWasChecked;
    private static ControlPar coreCloud;
    private static ControlPar controlCloud;
    private static ControlPar browserCloud;
    private static ControlPar plannerCloud;

    static {
        userDir = workingDir = System.getProperty("user.dir");
        shareResourcesDir = workingDir;
        configFileDir = workingDir;
        emergencyLogFileFolder = workingDir;
        tempDir = System.getProperty("java.io.tmpdir");
        syncTempDirCreation = new Object();
    }

    public static String getProjectName() {
        return projectName;
    }

    public static void setProjectName(String value) {
        projectName = value;
    }

    public static String getSuiteName() {
        return suiteName;
    }

    public static void setSuiteName(String value) {
        suiteName = value;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static void setApplicationName(String value) {
        applicationName = value;
    }

    public static String getApplicationShortName() {
        return applicationShortName;
    }

    public static void setApplicationShortName(String value) {
        applicationShortName = value;
    }

    public static String getApplicationVersion() {
        return applicationVersion;
    }

    public static void setApplicationVersion(String value) {
        applicationVersion = value;
    }

    public static String getApplicationCopyright() {
        return applicationCopyright;
    }

    public static void setApplicationCopyright(String value) {
        applicationCopyright = value;
    }

    public static String getApplicationFullName() {
        return applicationFullName;
    }

    public static void setApplicationFullName(String value) {
        applicationFullName = value;
    }

    public static String getWorkingDir() {
        return workingDir;
    }

    public static String getUserDir() {
        return userDir;
    }

    public static void setUserDir(String value) {
        Console.showMsg("CommonConst: user folder set to " + value);
        userDir = value;
    }

    public static String getShareResourcesDir() {
        return shareResourcesDir;
    }

    public static void setShareResourcesDir(String value) {
        Console.showMsg("CommonConst: resources folder set to " + value);
        shareResourcesDir = value;
    }

    public static String getConfigFileDir() {
        return configFileDir;
    }

    public static void setConfigFileDir(String value) {
        Console.showMsg("CommonConst: config file folder set to " + value);
        configFileDir = value;
    }

    public static String getEmergencyLogFileFolder() {
        return emergencyLogFileFolder;
    }

    public static void setEmergencyLogFileFolder(String value) {
        System.out.println("CommonConst: emergency log file folder set to " + value);
        emergencyLogFileFolder = value;
    }

    public static boolean getWriteAccessToShareDirEnabled() {
        return writeAccessToShareDir;
    }

    public static void setWriteAccessToShareDirEnabled(boolean value) {
        writeAccessToShareDir = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTempDir() {
        if (!tempDirWasChecked) {
            Object object = syncTempDirCreation;
            synchronized (object) {
                if (!tempDirWasChecked) {
                    File dir = new File(tempDir);
                    if (!dir.isDirectory() && !dir.mkdir()) {
                        Console.showError("Can not create temporary directory: " + tempDir);
                    }
                    tempDirWasChecked = true;
                }
            }
        }
        return tempDir;
    }

    public static void setTempDir(String value) {
        tempDir = value;
    }

    public static String getFileTimeFormat() {
        return fileTimeFormat;
    }

    public static void setFileTimeFormat(String format) {
        fileTimeFormat = format;
    }

    public static String getDateFormatOneDayPattern() {
        return dateFormatOneDayPattern;
    }

    public static void setDateFormatOneDayPattern(String value) {
        dateFormatOneDayPattern = value;
    }

    public static String getDateFormatIndividualPattern() {
        return dateFormatIndividualPattern;
    }

    public static void setDateFormatIndividualPattern(String value) {
        dateFormatIndividualPattern = value;
    }

    public static String getDateFormatLookPattern() {
        return dateFormatLookPattern;
    }

    public static void setDateFormatLookPattern(String value) {
        dateFormatLookPattern = value;
    }

    public static ControlPar getCoreCloud() {
        return coreCloud;
    }

    public static void setCoreCloud(ControlPar value) {
        coreCloud = value;
    }

    public static ControlPar getControlCloud() {
        return controlCloud;
    }

    public static void setControlCloud(ControlPar controlCloud) {
        CommonConst.controlCloud = controlCloud;
    }

    public static ControlPar getBrowserCloud() {
        return browserCloud;
    }

    public static void setBrowserCloud(ControlPar browserCloud) {
        CommonConst.browserCloud = browserCloud;
    }

    public static ControlPar getPlannerCloud() {
        return plannerCloud;
    }

    public static void setPlannerCloud(ControlPar plannerCloud) {
        CommonConst.plannerCloud = plannerCloud;
    }
}

