/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.project.CommonConst;
import java.io.File;
import java.io.IOException;

public class Exec {
    public static final int PROGRAM_HUNG_ERROR = -999999;
    public static final int IO_ERROR = -999998;
    private static final Runtime rt = Runtime.getRuntime();
    private static final File wDir = new File(CommonConst.getWorkingDir());
    private int waitTimeInMillisec = 5000;
    private String fullExeName = "";
    private String paramDefault = "";
    private String exeName = "";

    public Exec(String fullExeName, int waitTimeInMillisec) {
        this(fullExeName, waitTimeInMillisec, "");
    }

    public Exec(String fullExeName, int waitTimeInMillisec, String paramDefault) {
        this.fullExeName = fullExeName;
        this.waitTimeInMillisec = waitTimeInMillisec;
        this.paramDefault = paramDefault;
        this.exeName = new File(fullExeName).getName();
    }

    public int run() {
        return this.run(null);
    }

    public int run(String param) {
        return this.run(param, wDir);
    }

    public int run(Object params, File workingDir) {
        if (params != null && !(params instanceof String) && !(params instanceof String[])) {
            throw new IllegalArgumentException("params is type of " + params.getClass().getName() + ", but should be either " + String.class + " or " + String[].class);
        }
        String strParams = null;
        String[] paramTokens = null;
        if (params == null) {
            strParams = this.paramDefault;
        } else if (params instanceof String) {
            strParams = (String)params;
        } else {
            paramTokens = (String[])params;
        }
        int exitValue = 0;
        Process proc = null;
        long execTime = 0L;
        try {
            if (params instanceof String) {
                proc = rt.exec(String.valueOf(this.fullExeName) + (strParams.equals("") ? "" : " ") + strParams, null, workingDir);
            } else {
                String[] allTokens;
                if (paramTokens == null || paramTokens.length == 0) {
                    allTokens = new String[]{this.fullExeName};
                } else {
                    allTokens = new String[paramTokens.length + 1];
                    allTokens[0] = this.fullExeName;
                    int i = 0;
                    while (i < paramTokens.length) {
                        allTokens[i + 1] = paramTokens[i];
                        ++i;
                    }
                }
                proc = rt.exec(allTokens, null, workingDir);
            }
            while (true) {
                try {
                    exitValue = proc.exitValue();
                }
                catch (IllegalThreadStateException allTokens2) {
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException allTokens2) {
                        // empty catch block
                    }
                    if ((execTime += 200L) <= (long)this.waitTimeInMillisec) continue;
                    proc.destroy();
                    exitValue = -999999;
                    System.out.println(String.valueOf(this.exeName) + " is running more than " + FC.doubleToString((double)this.waitTimeInMillisec / 1000.0, 3, true) + " sec - killed!");
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
            exitValue = -999998;
        }
        return exitValue;
    }

    public static boolean isExternalError(int errorCode) {
        return errorCode != -999998 && errorCode != -999999;
    }
}

