/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project;

import edu.uml.lgdc.datatype.TailBuffer;
import java.util.List;

public class LogTail {
    private static final int DEFAULT_ERROR_LENGTH = 100;
    private static final int DEFAULT_OUTPUT_LENGTH = 300;
    private final TailBuffer<String> errorBuffer;
    private final TailBuffer<String> outputBuffer;

    public LogTail() {
        this(100, 300);
    }

    public LogTail(int errorBufLength, int outputBufLength) {
        this.errorBuffer = new TailBuffer(errorBufLength);
        this.outputBuffer = new TailBuffer(outputBufLength);
    }

    public void addLine(String line, boolean error) {
        if (!error) {
            this.outputBuffer.add(line);
        } else {
            this.errorBuffer.add(line);
        }
    }

    public List<String> getErrorLogTail() {
        return this.errorBuffer.getTail();
    }

    public List<String> getErrorLogTail(int maxNumberOfLines) {
        return this.errorBuffer.getTail(maxNumberOfLines);
    }

    public List<String> getOutputLogTail() {
        return this.outputBuffer.getTail();
    }

    public List<String> getOutputLogTail(int maxNumberOfLines) {
        return this.outputBuffer.getTail(maxNumberOfLines);
    }
}

