/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project;

import edu.uml.lgdc.datatype.MutableInteger;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.Msg;
import edu.uml.lgdc.time.TimeScale;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MsgLogManager {
    private Console console = null;
    private boolean printFirstOccurrenceImmediately;
    private Map<Msg, MutableInteger> msg2cnt = new HashMap<Msg, MutableInteger>();

    public MsgLogManager() {
        this(null);
    }

    public MsgLogManager(Console console) {
        this(console, false);
    }

    public MsgLogManager(Console console, boolean printFirstOccurrenceImmediately) {
        this.console = console;
        this.printFirstOccurrenceImmediately = printFirstOccurrenceImmediately;
    }

    public void init() {
        this.msg2cnt.clear();
    }

    public int add(Msg msg) {
        MutableInteger count = this.msg2cnt.get(msg);
        if (count == null) {
            count = new MutableInteger(1);
            this.msg2cnt.put(msg, count);
            if (this.printFirstOccurrenceImmediately) {
                this.printMes(msg);
            }
        } else {
            count.inc();
        }
        return count.get();
    }

    public int getQtyOfMes() {
        return this.msg2cnt.size();
    }

    public void printStat() {
        this.printStat(false);
    }

    public void printStat(boolean ifMoreThanOnce) {
        Set<Map.Entry<Msg, MutableInteger>> entries = this.msg2cnt.entrySet();
        for (Map.Entry<Msg, MutableInteger> entry : entries) {
            int count = entry.getValue().get();
            if (ifMoreThanOnce && count <= 1) continue;
            this.printMesWithCount(entry.getKey(), count);
        }
    }

    private void printMesWithCount(Msg msg, int count) {
        this.printMes(msg);
        this.printCount(count);
    }

    private void printCount(int count) {
        this.printMes("   was encountered " + count + " time(s)", false);
    }

    private void printMes(Msg msg) {
        this.printMes(msg, true);
    }

    private void printMes(Msg msg, boolean embedTime) {
        this.printMes(msg.get(), embedTime);
    }

    private void printMes(String s, boolean embedTime) {
        if (this.console != null) {
            this.console.logIt(s, embedTime);
        } else {
            if (embedTime) {
                s = TimeScale.prefixWithLocalTime(s, "  ");
            }
            System.out.println(s);
        }
    }
}

