/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.cadence;

import edu.uml.lgdc.project.cadence.CadenceAccumulatorFactory;
import edu.uml.lgdc.project.cadence.Max8PointCadenceAccumulatorFactory;
import edu.uml.lgdc.project.cadence.ThreePointCadenceAccumulatorFactory;
import java.util.HashMap;
import java.util.Map;

public enum CadenzaAccumulator {
    THREE_POINT(1, "3-points"),
    MAX_8_POINT(2, "3-to-8-points");

    private static final Map<Integer, CadenzaAccumulator> idMap;
    private static final Map<String, CadenzaAccumulator> nameMap;
    private final int id;
    private final String name;

    static {
        idMap = new HashMap<Integer, CadenzaAccumulator>();
        nameMap = new HashMap<String, CadenzaAccumulator>();
        CadenzaAccumulator[] cadenzaAccumulatorArray = CadenzaAccumulator.values();
        int n = cadenzaAccumulatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CadenzaAccumulator accumulator = cadenzaAccumulatorArray[n2];
            if (idMap.put(accumulator.getId(), accumulator) != null) {
                throw new RuntimeException("design error: duplication of id, " + accumulator.getId());
            }
            if (nameMap.put(accumulator.getName().toUpperCase(), accumulator) != null) {
                throw new RuntimeException("design error: duplication of name, " + accumulator.getName());
            }
            ++n2;
        }
    }

    private CadenzaAccumulator(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public <E> CadenceAccumulatorFactory<E> getFactory() {
        switch (this) {
            case THREE_POINT: {
                return new ThreePointCadenceAccumulatorFactory();
            }
            case MAX_8_POINT: {
                return new Max8PointCadenceAccumulatorFactory();
            }
        }
        throw new RuntimeException("design error: overlooked Cadence Accumulator, " + this.getName());
    }

    public static CadenzaAccumulator get(int id) {
        return idMap.get(id);
    }

    public static CadenzaAccumulator get(String name) {
        return nameMap.get(name.toUpperCase());
    }
}

