/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.commandlineparams;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandLineParam {
    private static final String[] SEP_1 = new String[]{"--", "="};
    private static final String[] SEP_2 = new String[]{"-", ":"};
    private final String keyPrefix;
    private final String key_value_separator;
    private final Set<String> paramKeys = new HashSet<String>();
    private final Map<String, String> paramValues = new HashMap<String, String>();
    private final List<String> notKeyParams = new ArrayList<String>();
    private final Set<String> duplicatedKeyOnly = new HashSet<String>();
    private final Set<String> duplicatedKeyValue = new HashSet<String>();

    public CommandLineParam(String[] params) {
        this(CommandLineParam.getSeps(params)[0], CommandLineParam.getSeps(params)[1], params);
    }

    private static String[] getSeps(String[] params) {
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (param.startsWith("--")) {
                return SEP_1;
            }
            if (param.startsWith("-")) {
                return SEP_2;
            }
            ++n2;
        }
        return SEP_1;
    }

    public CommandLineParam(String keyPrefix, String key_value_separator, String[] params) {
        assert (keyPrefix != null && keyPrefix.length() > 0);
        assert (key_value_separator != null && key_value_separator.length() > 0);
        this.keyPrefix = keyPrefix;
        this.key_value_separator = key_value_separator;
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (this.isStartAsKeyParam(param)) {
                String[] keyAndValue = this.getKeyAndValue(param);
                if (keyAndValue[1] == null) {
                    if (this.paramKeys.add(keyAndValue[0])) {
                        this.duplicatedKeyOnly.add(keyAndValue[0]);
                    }
                } else if (!this.paramValues.containsKey(keyAndValue[0])) {
                    this.paramValues.put(keyAndValue[0], keyAndValue[1]);
                } else {
                    this.duplicatedKeyValue.add(keyAndValue[0]);
                }
            } else {
                this.notKeyParams.add(param);
            }
            ++n2;
        }
    }

    public String[] getNotKeyParams() {
        return this.notKeyParams.toArray(new String[this.notKeyParams.size()]);
    }

    public String getKeyValue(String key) {
        assert (key != null && key.length() > 0);
        return this.paramValues.get(key);
    }

    public String getKeyValue(Set<String> keySynonyms) {
        assert (keySynonyms != null && keySynonyms.size() > 0);
        for (String synonym : keySynonyms) {
            if (!this.paramValues.containsKey(synonym)) continue;
            return this.paramValues.get(synonym);
        }
        return null;
    }

    public boolean isKeyExists(String key) {
        assert (key != null && key.length() > 0);
        return this.paramKeys.contains(key) || this.paramValues.get(key) != null;
    }

    public boolean isKeyExists(Set<String> keySynonyms) {
        assert (keySynonyms != null && keySynonyms.size() > 0);
        if (this.isKeyOnlyExists(keySynonyms)) {
            return true;
        }
        return this.getKeyValue(keySynonyms) != null;
    }

    public boolean isKeyOnlyExists(String key) {
        assert (key != null && key.length() > 0);
        return this.paramKeys.contains(key);
    }

    public boolean isKeyOnlyExists(Set<String> keySynonyms) {
        assert (keySynonyms != null && keySynonyms.size() > 0);
        for (String synonym : keySynonyms) {
            if (!this.paramKeys.contains(synonym)) continue;
            return true;
        }
        return false;
    }

    public String checkKeyOnlyParams(String[] keys) {
        KeyType[] keyTypes = new KeyType[keys.length];
        Arrays.fill((Object[])keyTypes, (Object)KeyType.KEY_ONLY);
        return this.checkKeyParams(keys, keyTypes);
    }

    public String checkKeyParams(String[] keys, KeyType[] keyTypes) {
        HashMap<String, KeyType> keyTypeMap = new HashMap<String, KeyType>();
        int i = 0;
        while (i < keys.length) {
            keyTypeMap.put(keys[i], keyTypes[i]);
            ++i;
        }
        return this.checkParams(keyTypeMap, false);
    }

    public String checkKeyParams(Map<String, KeyType> keyTypeMap) {
        return this.checkParams(keyTypeMap, false);
    }

    public String checkParams(String[] keys, KeyType[] keyTypes, boolean notKeyParamsAllowed) {
        HashMap<String, KeyType> keyTypeMap = new HashMap<String, KeyType>();
        int i = 0;
        while (i < keys.length) {
            keyTypeMap.put(keys[i], keyTypes[i]);
            ++i;
        }
        return this.checkParams(keyTypeMap, notKeyParamsAllowed);
    }

    public String checkParams(Map<String, KeyType> keyTypeMap, boolean notKeyParamsAllowed) {
        KeyType keyType;
        if (!notKeyParamsAllowed && this.notKeyParams.size() > 0) {
            return "illegal parameters: " + Arrays.toString(this.notKeyParams.toArray(new String[this.notKeyParams.size()]));
        }
        for (String key : this.paramKeys) {
            keyType = keyTypeMap.get(key);
            if (keyType != null) {
                if (keyType != KeyType.VALUE_ONLY) continue;
                return "key " + key + " has to be accompanied with value";
            }
            return "illegal key " + key;
        }
        for (String key : this.paramValues.keySet()) {
            keyType = keyTypeMap.get(key);
            if (keyType != null) {
                if (keyType != KeyType.KEY_ONLY) continue;
                return "key " + key + " doesn't have to be accompanied with value";
            }
            return "illegal key " + key;
        }
        return null;
    }

    public String checkParamsWithSynonyms(Map<Set<String>, KeyType> keyTypeMap, boolean notKeyParamsAllowed) {
        KeyType keyType;
        Set keySynonyms;
        if (!notKeyParamsAllowed && this.notKeyParams.size() > 0) {
            return "illegal parameters: " + Arrays.toString(this.notKeyParams.toArray(new String[this.notKeyParams.size()]));
        }
        HashMap<String, Set<String>> keyToSynonyms = new HashMap<String, Set<String>>();
        HashMap<Set<String>, List<String>> presentedAsKeyOnly = new HashMap<Set<String>, List<String>>();
        HashMap<Set<String>, List<String>> presentedAsKeyValue = new HashMap<Set<String>, List<String>>();
        for (Set<String> keySynonyms2 : keyTypeMap.keySet()) {
            for (String key : keySynonyms2) {
                keyToSynonyms.put(key, keySynonyms2);
            }
            presentedAsKeyOnly.put(keySynonyms2, new ArrayList());
            presentedAsKeyValue.put(keySynonyms2, new ArrayList());
        }
        for (String key : this.paramKeys) {
            keySynonyms = (Set)keyToSynonyms.get(key);
            if (keySynonyms != null) {
                keyType = keyTypeMap.get(keySynonyms);
                if (keyType == KeyType.VALUE_ONLY) {
                    return "key " + key + " has to be accompanied with value";
                }
                ((List)presentedAsKeyOnly.get(keySynonyms)).add(key);
                continue;
            }
            return "illegal key " + key;
        }
        for (String key : this.paramValues.keySet()) {
            keySynonyms = (Set)keyToSynonyms.get(key);
            if (keySynonyms != null) {
                keyType = keyTypeMap.get(keySynonyms);
                if (keyType == KeyType.KEY_ONLY) {
                    return "key " + key + " doesn't have to be accompanied with value";
                }
                ((List)presentedAsKeyValue.get(keySynonyms)).add(key);
                continue;
            }
            return "illegal key " + key;
        }
        String errMsg = "";
        String dup = this.checkDuplicationOfSynonyms(presentedAsKeyOnly);
        if (!dup.isEmpty()) {
            errMsg = String.valueOf(errMsg) + "Duplication of key-only synonyms of the same 'keyword'\n" + dup;
        }
        if (!(dup = this.checkDuplicationOfSynonyms(presentedAsKeyValue)).isEmpty()) {
            errMsg = String.valueOf(errMsg) + "Duplication of key-value synonyms of the same 'keyword'\n" + dup;
        }
        return errMsg.isEmpty() ? null : errMsg;
    }

    public String[] extractArgs(Map<Set<String>, KeyType> synonym2keyTypeMap) {
        ArrayList<String> argList = new ArrayList<String>();
        block0: for (Set<String> keySynonyms : synonym2keyTypeMap.keySet()) {
            KeyType keyType = synonym2keyTypeMap.get(keySynonyms);
            if (keyType != KeyType.VALUE_ONLY) {
                boolean found = false;
                for (String key : keySynonyms) {
                    if (!this.paramKeys.contains(key)) continue;
                    argList.add("--" + key);
                    found = true;
                    break;
                }
                if (found) continue;
            }
            if (keyType == KeyType.KEY_ONLY) continue;
            for (String key : keySynonyms) {
                String value = this.paramValues.get(key);
                if (value == null) continue;
                argList.add("--" + key + "=" + value);
                continue block0;
            }
        }
        return argList.toArray(new String[0]);
    }

    private String checkDuplicationOfSynonyms(Map<Set<String>, List<String>> presented) {
        String dupMsg = "";
        for (List<String> list : presented.values()) {
            if (list.size() <= 1) continue;
            dupMsg = String.valueOf(dupMsg) + Arrays.toString(list.toArray(new String[list.size()])) + "\n";
        }
        return dupMsg;
    }

    private String[] getKeyAndValue(String par) {
        String parWithoutPrefix = par.substring(this.keyPrefix.length());
        int sepPos = parWithoutPrefix.indexOf(this.key_value_separator);
        if (sepPos < 0) {
            String[] stringArray = new String[2];
            stringArray[0] = parWithoutPrefix;
            return stringArray;
        }
        return new String[]{parWithoutPrefix.substring(0, sepPos), parWithoutPrefix.substring(sepPos + this.key_value_separator.length())};
    }

    private boolean isStartAsKeyParam(String par) {
        return par.startsWith(this.keyPrefix);
    }

    public static enum KeyType {
        KEY_ONLY,
        VALUE_ONLY,
        KEY_OR_VALUE;

    }
}

