/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.commandlineparams;

import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.commandlineparams.CommandLineParam;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ConfigFileDir {
    public static final Set<String> KEYS = new HashSet<String>(Arrays.asList("config-dir", "cd"));
    public static final String NOT_SET = new String();
    private static String errMsg = null;

    private ConfigFileDir() {
    }

    public static boolean readAndSet(CommandLineParam commandLineParam) {
        errMsg = ConfigFileDir.readAndSet(commandLineParam, KEYS);
        return errMsg == null;
    }

    private static String readAndSet(CommandLineParam commandLineParam, Set<String> synonyms) {
        String errMsg = null;
        String configFileDir = null;
        if (commandLineParam.isKeyExists(synonyms)) {
            configFileDir = commandLineParam.getKeyValue(synonyms);
            if (configFileDir != null) {
                if (new File(configFileDir).isDirectory()) {
                    try {
                        configFileDir = new File(configFileDir).getCanonicalPath();
                    }
                    catch (IOException ex) {
                        errMsg = ex.toString();
                    }
                } else {
                    errMsg = "Illegal directory " + configFileDir + " does not exist";
                }
            }
        } else {
            return null;
        }
        if (errMsg != null) {
            Console.showError("Configuration folder cannot be located at " + configFileDir);
            return errMsg;
        }
        if (configFileDir != null) {
            CommonConst.setConfigFileDir(configFileDir);
            return null;
        }
        return NOT_SET;
    }

    public static void showHelp() {
        System.out.printf("%-25s %s%n", "--config-dir=dir", "Config file directory. Software will look in this folder for its configuration files");
        System.out.printf("%-25s %s%n", "--cd=dir", "Config file directory. Software will look in this folder for its configuration files");
        System.out.printf("%-25s %s%n", "", "If not specified, config file directory is working directory");
    }

    public static String getErrMsg() {
        return errMsg;
    }
}

