/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.commandlineparams;

import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.commandlineparams.CommandLineParam;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class EmergencyLogFileDir {
    public static final Set<String> KEYS = new HashSet<String>(Arrays.asList("emergency-dir", "ed"));
    public static final String NOT_SET = new String();
    private static String errMsg = null;

    private EmergencyLogFileDir() {
    }

    public static boolean readAndSet(CommandLineParam commandLineParam) {
        errMsg = EmergencyLogFileDir.readAndSet(commandLineParam, KEYS);
        return errMsg == null;
    }

    private static String readAndSet(CommandLineParam commandLineParam, Set<String> synonyms) {
        String errMsg = null;
        String emergencyLogFileDir = null;
        if (commandLineParam.isKeyExists(synonyms)) {
            emergencyLogFileDir = commandLineParam.getKeyValue(synonyms);
            if (emergencyLogFileDir != null) {
                if (new File(emergencyLogFileDir).isDirectory()) {
                    try {
                        emergencyLogFileDir = new File(emergencyLogFileDir).getCanonicalPath();
                    }
                    catch (IOException ex) {
                        errMsg = ex.toString();
                    }
                } else {
                    errMsg = "Illegal directory " + emergencyLogFileDir + " does not exist";
                }
            }
        } else {
            return null;
        }
        if (errMsg != null) {
            Console.showError("Emergency Logfile folder cannot be located at " + emergencyLogFileDir);
            return errMsg;
        }
        if (emergencyLogFileDir != null) {
            CommonConst.setEmergencyLogFileFolder(emergencyLogFileDir);
            return null;
        }
        return NOT_SET;
    }

    public static void showHelp() {
        System.out.printf("%-25s %s%n", "--emergency-dir=dir", "Using this parameter sets a location for the emergency log file. ");
        System.out.printf("%-25s %s%n", "", "This location is used during application startup before the configuration is read.");
        System.out.printf("%-25s %s%n", "", "Should the application crash before the configuration is completely read");
        System.out.printf("%-25s %s%n", "", "it will attempt to create a log in the location specified by this parameter.");
        System.out.printf("%-25s %s%n", "", "If the parameter is unspecified then the application working directory will be used.");
        System.out.printf("%-25s %s%n", "", "This parameter should be set to match the 'LogFileFolder' parameter within Core.config");
        System.out.printf("%-25s %s%n", "", "if it has been changed to a location other than the application working directory.");
        System.out.printf("%-25s %s%n", "--ed=dir", "Alternative parameter for --emergency-dir.");
    }

    public static String getErrMsg() {
        return errMsg;
    }
}

