/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.commandlineparams;

import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.commandlineparams.CommandLineParam;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SharedResourcesDir {
    public static final Set<String> KEYS = new HashSet<String>(Arrays.asList("share-dir", "sd"));
    public static final String NOT_SET = new String();
    private static String errMsg = null;

    private SharedResourcesDir() {
    }

    public static boolean readAndSet(CommandLineParam commandLineParam) {
        errMsg = SharedResourcesDir.readAndSet(commandLineParam, KEYS);
        return errMsg == null;
    }

    private static String readAndSet(CommandLineParam commandLineParam, Set<String> synonyms) {
        String errMsg = null;
        String sharedDir = null;
        if (commandLineParam.isKeyExists(synonyms)) {
            sharedDir = commandLineParam.getKeyValue(synonyms);
            if (sharedDir != null) {
                if (new File(sharedDir).isDirectory()) {
                    try {
                        sharedDir = new File(sharedDir).getCanonicalPath();
                    }
                    catch (IOException ex) {
                        errMsg = ex.toString();
                    }
                } else {
                    errMsg = "Illegal directory " + sharedDir + " does not exist";
                }
            }
        } else {
            return null;
        }
        if (errMsg != null) {
            return errMsg;
        }
        if (sharedDir != null) {
            CommonConst.setShareResourcesDir(sharedDir);
            return null;
        }
        return NOT_SET;
    }

    public static void showHelp() {
        System.out.printf("%-25s %s%n", "--shared-dir=dir", "Shared resources directory for the application");
        System.out.printf("%-25s %s%n", "--sd=dir", "Shared resources directory for the application");
        System.out.printf("%-25s %s%n", "", "If not specified, user directory will be used to load resources");
    }

    public static String getErrMsg() {
        return errMsg;
    }
}

