/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.commandlineparams;

import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.commandlineparams.CommandLineParam;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class UserDir {
    public static final Set<String> KEYS = new HashSet<String>(Arrays.asList("user-dir", "ud"));
    public static final String NOT_SET = new String();
    private static String errMsg = null;

    private UserDir() {
    }

    public static boolean readAndSet(CommandLineParam commandLineParam) {
        errMsg = UserDir.readAndSet(commandLineParam, KEYS);
        return errMsg == null;
    }

    private static String readAndSet(CommandLineParam commandLineParam, Set<String> synonyms) {
        String errMsg = null;
        String userDir = null;
        if (commandLineParam.isKeyExists(synonyms)) {
            userDir = commandLineParam.getKeyValue(synonyms);
            if (userDir != null) {
                if (new File(userDir).isDirectory()) {
                    try {
                        userDir = new File(userDir).getCanonicalPath();
                    }
                    catch (IOException ex) {
                        errMsg = ex.toString();
                    }
                } else {
                    errMsg = "Illegal directory " + userDir + " does not exist";
                }
            }
        } else {
            return null;
        }
        if (errMsg != null) {
            return errMsg;
        }
        if (userDir != null) {
            CommonConst.setUserDir(userDir);
            return null;
        }
        return NOT_SET;
    }

    public static void showHelp() {
        System.out.printf("%-25s %s%n", "--user-dir=dir", "Working directory for the application");
        System.out.printf("%-25s %s%n", "--ud=dir", "Working directory for the application");
        System.out.printf("%-25s %s%n", "", "If not specified, user directory is the directory where the application resides");
    }

    public static String getErrMsg() {
        return errMsg;
    }
}

