/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.options;

import edu.uml.lgdc.project.settings.StrictProperties;

public class CastAwaySLOptions {
    public static final int CAST = 0;
    public static final int KEEP = 1;
    public static final int LOW = 0;
    public static final int HIGH = 1;
    public static final int MAX_RANGE = 8192;
    private boolean enabled;
    private boolean keep;
    private int range;
    private boolean high;
    private String prefix = "";

    public CastAwaySLOptions() {
        this("");
    }

    public CastAwaySLOptions(String prefix) {
        this.prefix = prefix;
        this.setDefaults();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDefaults() {
        this.keep = false;
        this.high = true;
        this.range = 10;
        this.enabled = true;
    }

    public void get(StrictProperties properties) {
        this.keep = properties.get(String.valueOf(this.prefix) + "Keep", this.high);
        this.high = properties.get(String.valueOf(this.prefix) + "High", this.high);
        this.range = properties.get(String.valueOf(this.prefix) + "Range", this.range);
        this.enabled = properties.get(String.valueOf(this.prefix) + "Enabled", this.enabled);
    }

    public void put(StrictProperties properties) {
        properties.put(String.valueOf(this.prefix) + "Keep", this.keep);
        properties.put(String.valueOf(this.prefix) + "High", this.high);
        properties.put(String.valueOf(this.prefix) + "Range", this.range);
        properties.put(String.valueOf(this.prefix) + "Enabled", this.enabled);
    }

    public void set(CastAwaySLOptions options) {
        this.prefix = options.prefix;
        this.keep = options.keep;
        this.high = options.high;
        this.range = options.range;
        this.enabled = options.enabled;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CastAwaySLOptions) {
            CastAwaySLOptions options = (CastAwaySLOptions)obj;
            return this.keep == options.keep && this.high == options.high && this.range == options.range && this.enabled == options.enabled;
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean getKeepEnable() {
        return this.keep;
    }

    public void setKeepEnable(boolean flag) {
        this.keep = flag;
    }

    public boolean getHighEnable() {
        return this.high;
    }

    public void setHighEnable(boolean flag) {
        this.high = flag;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int value) {
        this.range = value;
    }

    public static boolean isLegalRange(int val) {
        return val >= 0 && val <= 8192;
    }

    public static int getCorrectedRange(int val, int defaultVal) {
        if (val < 0) {
            val = defaultVal;
        } else if (val > 8192) {
            val = 8192;
        }
        return val;
    }
}

