/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.options;

import edu.uml.lgdc.project.settings.ApplicationProperties;

public class LogoOptions {
    private boolean useExternal;
    private String externalFile;
    protected String prefix = "";

    public LogoOptions() {
        this("");
    }

    public LogoOptions(String prefix) {
        this.setPrefix(prefix);
        this.setDefaults();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.setPrefix_1(prefix);
    }

    private void setPrefix_1(String prefix) {
        this.prefix = prefix;
    }

    public void setDefaults() {
        this.useExternal = false;
        this.externalFile = "";
    }

    public void get(ApplicationProperties properties) {
        this.useExternal = properties.get(String.valueOf(this.prefix) + "UseExternalLogo", this.useExternal);
        this.externalFile = properties.get(String.valueOf(this.prefix) + "ExternalLogoFile", this.externalFile);
    }

    public void put(ApplicationProperties properties) {
        properties.put(String.valueOf(this.prefix) + "UseExternalLogo", this.useExternal);
        properties.put(String.valueOf(this.prefix) + "ExternalLogoFile", this.externalFile);
    }

    public void set(LogoOptions options) {
        this.prefix = options.prefix;
        this.useExternal = options.useExternal;
        this.externalFile = options.externalFile;
        this.setPrefix_1(this.prefix);
    }

    public Object clone() {
        try {
            LogoOptions options = (LogoOptions)super.clone();
            options.set(this);
            return options;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LogoOptions) {
            LogoOptions options = (LogoOptions)obj;
            return this.useExternal == options.useExternal && this.externalFile == options.externalFile;
        }
        return false;
    }

    public boolean getUseExternalEnable() {
        return this.useExternal;
    }

    public void setUseExternalEnable(boolean value) {
        this.useExternal = value;
    }

    public String getExternalFile() {
        return this.externalFile;
    }

    public void setExternalFile(String value) {
        this.externalFile = value;
    }
}

