/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.options;

import edu.uml.lgdc.datatype.MutableString;
import edu.uml.lgdc.graph.SaveImage;
import edu.uml.lgdc.project.settings.ApplicationProperties;

public class SavePictureOptions
implements Cloneable {
    private static final String NAME_USE_FIXED_PICTURE_SIZE_FOR_OUTPUT = "UseFixedPictureSizeForOutput";
    private static final String NAME_PICTURE_WIDTH = "PictureWidth";
    private static final String NAME_PICTURE_HEIGHT = "PictureHeight";
    private static final String NAME_PICTURE_FORMAT = "PictureFormat";
    protected String namePictureFormat;
    private static final String NAME_PRESENTATION_QUALITY = "SavePicturePresentationQuality";
    private static final String NAME_KEEP_RATIO = "PictureKeepRatio";
    private static final String NAME_X_SCALE = "PictureXScale";
    private static final String NAME_Y_SCALE = "PictureYScale";
    private static final String NAME_PATH = "PicturePath";
    protected boolean useFixedPictureSizeForOutput;
    protected int pictureWidth;
    protected int pictureHeight;
    protected SaveImage.Format pictureFormat;
    protected boolean presentationQuality;
    protected boolean keepRatio;
    protected double xScale;
    protected double yScale;
    protected MutableString picturePath;
    protected String prefix = "";

    public SavePictureOptions() {
        this("");
    }

    public SavePictureOptions(String prefix) {
        this(prefix, NAME_PICTURE_FORMAT);
    }

    public SavePictureOptions(String prefix, String namePictureFormat) {
        this.namePictureFormat = namePictureFormat;
        this.setPrefix(prefix);
        this.setDefaults();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDefaults() {
        this.useFixedPictureSizeForOutput = false;
        this.pictureWidth = 800;
        this.pictureHeight = 600;
        this.pictureFormat = SaveImage.Format.PNG;
        this.presentationQuality = true;
        this.keepRatio = true;
        this.xScale = 1.0;
        this.yScale = 1.0;
        this.picturePath = new MutableString("");
    }

    public void get(ApplicationProperties properties) {
        this.useFixedPictureSizeForOutput = properties.get(String.valueOf(this.prefix) + NAME_USE_FIXED_PICTURE_SIZE_FOR_OUTPUT, this.useFixedPictureSizeForOutput);
        this.pictureWidth = properties.get(String.valueOf(this.prefix) + NAME_PICTURE_WIDTH, this.pictureWidth);
        this.pictureHeight = properties.get(String.valueOf(this.prefix) + NAME_PICTURE_HEIGHT, this.pictureHeight);
        this.pictureFormat = SaveImage.Format.fromStr(properties.get(String.valueOf(this.prefix) + this.namePictureFormat, this.pictureFormat.ext()), SaveImage.Format.PNG);
        this.presentationQuality = properties.get(String.valueOf(this.prefix) + NAME_PRESENTATION_QUALITY, this.presentationQuality);
        this.keepRatio = properties.get(String.valueOf(this.prefix) + NAME_KEEP_RATIO, this.keepRatio);
        this.xScale = properties.get(String.valueOf(this.prefix) + NAME_X_SCALE, this.xScale);
        this.yScale = properties.get(String.valueOf(this.prefix) + NAME_Y_SCALE, this.yScale);
        this.setPicturePath(properties.get(String.valueOf(this.prefix) + NAME_PATH, this.picturePath.get()));
    }

    public void put(ApplicationProperties properties) {
        properties.put(String.valueOf(this.prefix) + NAME_USE_FIXED_PICTURE_SIZE_FOR_OUTPUT, this.useFixedPictureSizeForOutput);
        properties.put(String.valueOf(this.prefix) + NAME_PICTURE_WIDTH, this.pictureWidth);
        properties.put(String.valueOf(this.prefix) + NAME_PICTURE_HEIGHT, this.pictureHeight);
        properties.put(String.valueOf(this.prefix) + this.namePictureFormat, this.pictureFormat.toString().toLowerCase());
        properties.put(String.valueOf(this.prefix) + NAME_PRESENTATION_QUALITY, this.presentationQuality);
        properties.put(String.valueOf(this.prefix) + NAME_KEEP_RATIO, this.keepRatio);
        properties.put(String.valueOf(this.prefix) + NAME_X_SCALE, this.xScale);
        properties.put(String.valueOf(this.prefix) + NAME_Y_SCALE, this.yScale);
        properties.put(String.valueOf(this.prefix) + NAME_PATH, this.picturePath.get());
    }

    public void set(SavePictureOptions options) {
        this.prefix = options.prefix;
        this.useFixedPictureSizeForOutput = options.useFixedPictureSizeForOutput;
        this.pictureWidth = options.pictureWidth;
        this.pictureHeight = options.pictureHeight;
        this.pictureFormat = options.pictureFormat;
        this.presentationQuality = options.presentationQuality;
        this.keepRatio = options.keepRatio;
        this.xScale = options.xScale;
        this.yScale = options.yScale;
        this.picturePath = (MutableString)options.picturePath.clone();
    }

    public Object clone() {
        try {
            SavePictureOptions options = (SavePictureOptions)super.clone();
            options.set(this);
            return options;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SavePictureOptions) {
            SavePictureOptions options = (SavePictureOptions)obj;
            return this.useFixedPictureSizeForOutput == options.useFixedPictureSizeForOutput && this.pictureWidth == options.pictureWidth && this.pictureHeight == options.pictureHeight && this.pictureFormat == options.pictureFormat && this.presentationQuality == options.presentationQuality && this.keepRatio == options.keepRatio && this.xScale == options.xScale && this.yScale == options.yScale && this.picturePath.equals(options.picturePath);
        }
        return false;
    }

    public boolean getUseFixedPictureSizeForOutputEnable() {
        return this.useFixedPictureSizeForOutput;
    }

    public void setUseFixedPictureSizeForOutputEnable(boolean flag) {
        this.useFixedPictureSizeForOutput = flag;
    }

    public int getPictureWidth() {
        return this.pictureWidth;
    }

    public void setPictureWidth(int value) {
        this.pictureWidth = value;
    }

    public int getPictureHeight() {
        return this.pictureHeight;
    }

    public void setPictureHeight(int value) {
        this.pictureHeight = value;
    }

    public SaveImage.Format getPictureFormat() {
        return this.pictureFormat;
    }

    public void setPictureFormat(SaveImage.Format value) {
        this.pictureFormat = value;
    }

    public boolean getPresentationQualityEnable() {
        return this.presentationQuality;
    }

    public void setPresentationQualityEnable(boolean value) {
        this.presentationQuality = value;
    }

    public boolean getKeepRatioEnable() {
        return this.keepRatio;
    }

    public void setKeepRatioEnable(boolean value) {
        this.keepRatio = value;
    }

    public double getXScale() {
        return this.xScale;
    }

    public void setXScale(double value) {
        this.xScale = value;
    }

    public double getYScale() {
        return this.yScale;
    }

    public void setYScale(double value) {
        this.yScale = value;
    }

    public MutableString getPicturePath() {
        return this.picturePath;
    }

    public void setPicturePath(String str) {
        this.picturePath.put(str);
    }

    public void setPicturePath(MutableString str) {
        this.picturePath = str;
    }
}

