/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.options;

import edu.uml.lgdc.project.settings.ApplicationProperties;

public class SmoothingOptions
implements Cloneable {
    protected double winLength;
    protected boolean useErrorsAsWeights;
    protected double tolerableError;
    protected String prefix = "";

    public SmoothingOptions() {
        this("");
    }

    public SmoothingOptions(String prefix) {
        this.setPrefix(prefix);
        this.setDefaults();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.setPrefix_1(prefix);
    }

    private void setPrefix_1(String prefix) {
        this.prefix = prefix;
    }

    public void setDefaults() {
        this.winLength = 0.0;
        this.useErrorsAsWeights = true;
        this.tolerableError = 1.0;
    }

    public void get(ApplicationProperties properties) {
        this.winLength = properties.get(String.valueOf(this.prefix) + "SmoothingWinLength", this.winLength);
        this.useErrorsAsWeights = properties.get(String.valueOf(this.prefix) + "SmoothingUseErrorsAsWeights", this.useErrorsAsWeights);
        this.tolerableError = properties.get(String.valueOf(this.prefix) + "TolerableError", this.tolerableError);
    }

    public void put(ApplicationProperties properties) {
        properties.put(String.valueOf(this.prefix) + "SmoothingWinLength", this.winLength);
        properties.put(String.valueOf(this.prefix) + "SmoothingUseErrorsAsWeights", this.useErrorsAsWeights);
        properties.put(String.valueOf(this.prefix) + "TolerableError", this.tolerableError);
    }

    public void set(SmoothingOptions options) {
        this.prefix = options.prefix;
        this.winLength = options.winLength;
        this.useErrorsAsWeights = options.useErrorsAsWeights;
        this.tolerableError = options.tolerableError;
        this.setPrefix_1(this.prefix);
    }

    public Object clone() {
        try {
            SmoothingOptions options = (SmoothingOptions)super.clone();
            options.set(this);
            return options;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SmoothingOptions) {
            SmoothingOptions options = (SmoothingOptions)obj;
            return this.prefix.equals(options.prefix) && this.winLength == options.winLength && this.useErrorsAsWeights == options.useErrorsAsWeights && this.tolerableError == options.tolerableError;
        }
        return false;
    }

    public double getWinLength() {
        return this.winLength;
    }

    public void setWinLength(double value) {
        this.winLength = value;
    }

    public boolean getUseErrorsAsWeightsEnable() {
        return this.useErrorsAsWeights;
    }

    public void setUseErrorsAsWeightsEnable(boolean flag) {
        this.useErrorsAsWeights = flag;
    }

    public double getTolerableError() {
        return this.tolerableError;
    }

    public void setTolerableError(double value) {
        this.tolerableError = value;
    }

    public boolean isLegalWinLen(int val) {
        return val >= 0;
    }

    public double getCorrectedWinLen(double val, double defaultVal) {
        if (val < 0.0) {
            val = defaultVal;
        }
        return val;
    }

    public boolean isLegalTolerableError(double val) {
        return val >= 0.0;
    }

    public double getCorrectedTolerableError(double val, double defaultVal) {
        if (val < 0.0) {
            val = defaultVal;
        }
        return val;
    }
}

