/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.format.StrUtil;
import java.io.IOException;
import java.util.Map;

public class BaseSettings {
    private String strValue;
    private int parCode;
    private String filename;
    private FileRW file;
    private String line;
    private int lineNumber = 0;

    public BaseSettings(String filename) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        this.filename = filename;
        this.file = new FileRW(filename, "r");
    }

    public BaseSettings(FileRW file) {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        this.file = file;
        this.filename = file.getFullFileName();
    }

    public int getNextParameterText() throws IOException {
        boolean error = false;
        try {
            do {
                try {
                    this.line = this.file.readLine();
                }
                catch (IOException e) {
                    error = true;
                    throw new IOException("File error reading " + this.filename + "\n" + e);
                }
                if (this.line == null) {
                    try {
                        this.file.close();
                    }
                    catch (IOException e) {
                        e.toString();
                    }
                    this.file = null;
                    return 0;
                }
                ++this.lineNumber;
            } while (this.line.length() < 4 || this.line.charAt(0) != '*');
            try {
                this.parCode = Integer.parseInt(this.line.substring(1, 4));
            }
            catch (NumberFormatException e) {
                error = true;
                throw new IOException("Bad parameter line in\t" + this.filename + ":" + "\n" + this.line);
            }
            try {
                int pos1 = this.line.indexOf(60) + 1;
                while (this.line.charAt(pos1) == ' ') {
                    ++pos1;
                }
                int pos2 = this.line.indexOf(62, pos1) - 1;
                while (this.line.charAt(pos2) == ' ') {
                    --pos2;
                }
                this.strValue = pos2 >= pos1 ? this.line.substring(pos1, pos2 + 1) : "";
            }
            catch (Exception e) {
                error = true;
                throw new IOException("Bad format of parameter in " + this.filename + ":" + "\n" + this.line);
            }
        }
        finally {
            if (error && this.file != null) {
                try {
                    this.file.close();
                }
                catch (IOException e) {
                    System.out.println(e.toString());
                }
                this.file = null;
            }
        }
        return this.parCode;
    }

    public String getLine() {
        return this.line;
    }

    public String getString() {
        return this.strValue;
    }

    public int parseInteger() throws IOException {
        try {
            return Integer.parseInt(this.strValue);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad integer format of parameter " + this.parCode + " in UDD file " + this.filename);
        }
    }

    public int[] parseIntArray() throws IOException {
        int[] values = null;
        String[] strArr = StrUtil.listToArray(this.strValue, " ,", true);
        values = new int[strArr.length];
        int i = 0;
        while (i < values.length) {
            try {
                values[i] = Integer.valueOf(strArr[i]);
            }
            catch (NumberFormatException e) {
                throw new IOException("Bad integer format of parameter " + this.parCode + " in UDD file " + this.filename);
            }
            ++i;
        }
        return values;
    }

    public int[][] parseIntPairsArray() throws IOException {
        int[][] values = null;
        String[] strArr = StrUtil.listToArray(this.strValue, " ,", true);
        values = new int[strArr.length][2];
        int i = 0;
        while (i < values.length) {
            int dashPos = strArr[i].indexOf(45);
            if (dashPos < 0) {
                throw new IOException("Bad integer format of parameter " + this.parCode + " in UDD file " + this.filename + "\n" + "No dash sign inside of pair");
            }
            try {
                values[i][0] = Integer.valueOf(strArr[i].substring(0, dashPos));
                values[i][1] = Integer.valueOf(strArr[i].substring(dashPos + 1));
            }
            catch (NumberFormatException e) {
                throw new IOException("Bad integer format of parameter " + this.parCode + " in UDD file " + this.filename);
            }
            ++i;
        }
        return values;
    }

    public double parseDouble() throws IOException {
        Double d;
        try {
            d = Double.valueOf(this.strValue);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad double format of parameter " + this.parCode + " in UDD file " + this.filename);
        }
        return d;
    }

    public double[] parseDoubleArray() throws IOException {
        double[] values = null;
        String[] strArr = StrUtil.listToArray(this.strValue, " ,", true);
        values = new double[strArr.length];
        int i = 0;
        while (i < values.length) {
            try {
                values[i] = Double.valueOf(strArr[i]);
            }
            catch (NumberFormatException e) {
                throw new IOException("Bad double format of parameter " + this.parCode + " in UDD file " + this.filename);
            }
            ++i;
        }
        return values;
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getParCode() {
        return this.parCode;
    }

    public void close() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.file = null;
        }
    }

    public static String getSettingsAsStr(Map<String, Map<String, String>> options) {
        StringBuilder sb = new StringBuilder(16384);
        for (String sectionName : options.keySet()) {
            Map<String, String> params = options.get(sectionName);
            if (params.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("[").append(sectionName).append("]\n");
            int size = params.keySet().size();
            int count = 0;
            for (String name : params.keySet()) {
                sb.append(name).append("=").append(params.get(name));
                if (++count >= size) continue;
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

