/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ContentType {
    MIXED(1),
    CORE(2),
    DEBUG(4),
    EXPORT(8),
    QUERY(16),
    DBSPEC(32),
    DISPLAY(64),
    MISC(128);

    private static final Map<Integer, ContentType> mapById;
    private final int id;

    static {
        mapById = new HashMap<Integer, ContentType>();
        ContentType[] contentTypeArray = ContentType.values();
        int n = contentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentType contentType = contentTypeArray[n2];
            if (mapById.put(contentType.getId(), contentType) != null) {
                throw new RuntimeException("Design error: duplicated Id, " + contentType.getId());
            }
            ++n2;
        }
    }

    private ContentType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ContentType get(int id) {
        return mapById.get(id);
    }

    public static boolean isIncluded(ContentType type, int selection) {
        return (type.getId() & selection) != 0;
    }

    public static boolean isIncluded(ContentType type, EnumSet<ContentType> selection) {
        return selection.contains((Object)type);
    }
}

