/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

public class FromStrHelper {
    public static Result getInt(String strValue) {
        if (strValue != null && !(strValue = strValue.trim()).isEmpty()) {
            try {
                return new Result(null, Integer.parseInt(strValue));
            }
            catch (NumberFormatException ex) {
                return new Result(ex.getMessage(), null);
            }
        }
        return new Result(null, null, true);
    }

    public static Result getPositiveInt(String strValue) {
        Result result = FromStrHelper.getInt(strValue);
        if (result.errMsg == null && !result.isDefaultValue) {
            int intVal = (Integer)result.value;
            if (intVal >= 0) {
                return result;
            }
            return new Result("value is < 0, " + intVal, null);
        }
        return result;
    }

    public static Result getStrictPositiveInt(String strValue) {
        Result result = FromStrHelper.getInt(strValue);
        if (result.errMsg == null && !result.isDefaultValue) {
            int intVal = (Integer)result.value;
            if (intVal > 0) {
                return result;
            }
            return new Result("value is <= 0, " + intVal, null);
        }
        return result;
    }

    public static Result getBoolean(String strValue, boolean defaultValue) {
        if (strValue != null && !(strValue = strValue.trim()).isEmpty()) {
            if (strValue.equalsIgnoreCase("true") || strValue.equalsIgnoreCase("yes")) {
                return new Result(null, true);
            }
            if (strValue.equalsIgnoreCase("false") || strValue.equalsIgnoreCase("no")) {
                return new Result(null, false);
            }
            return new Result("illegal boolean value, " + strValue, null);
        }
        return new Result(null, defaultValue, true);
    }

    public static class Result {
        public final String errMsg;
        public final Object value;
        public final boolean isDefaultValue;

        Result(String errMsg, Object value) {
            this(errMsg, value, false);
        }

        Result(String errMsg, Object value, boolean isDefaultValue) {
            if (errMsg != null && value != null) {
                throw new IllegalArgumentException("value has to be null when errMsg is not null");
            }
            this.errMsg = errMsg;
            this.value = value;
            this.isDefaultValue = isDefaultValue;
        }
    }
}

