/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

import edu.uml.lgdc.project.settings.ContentType;
import java.util.Objects;

public class OptionDesc {
    private final Object defaultValue;
    private final ContentType contentType;
    private int[] rangeOfOccurrences;

    public OptionDesc(Object defaultValue, ContentType contentType) {
        int[] nArray = new int[2];
        nArray[1] = 1;
        this(defaultValue, nArray, contentType);
    }

    public OptionDesc(Object defaultValue, int[] rangeOfOccurrences) {
        this(defaultValue, rangeOfOccurrences, ContentType.MIXED);
    }

    public OptionDesc(Object defaultValue, int[] rangeOfOccurrences, ContentType contentType) {
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.rangeOfOccurrences = nArray;
        this.defaultValue = defaultValue;
        this.setRangeOfOccurrences(rangeOfOccurrences);
        this.contentType = contentType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public boolean isIncluded(int contentTypes) {
        return ContentType.isIncluded(this.contentType, contentTypes);
    }

    public int[] getRangeOfOccurrences() {
        return this.rangeOfOccurrences;
    }

    public void setRangeOfOccurrences(int[] rangeOfOccurrences) {
        Objects.requireNonNull(rangeOfOccurrences);
        assert (rangeOfOccurrences.length == 2) : "range has to be array of 2 elements, but is " + rangeOfOccurrences.length;
        assert (rangeOfOccurrences[0] >= 0);
        assert (rangeOfOccurrences[1] >= 0);
        assert (rangeOfOccurrences[1] == 0 || rangeOfOccurrences[1] >= rangeOfOccurrences[0]);
        this.rangeOfOccurrences = rangeOfOccurrences;
    }

    public boolean isMultiOption() {
        return this.rangeOfOccurrences[1] != 1;
    }

    public boolean isNumberOfOccurrencesIsInRange(int numberOfOccurrences) {
        if (this.rangeOfOccurrences[1] > 0) {
            return numberOfOccurrences >= this.rangeOfOccurrences[0] && numberOfOccurrences <= this.rangeOfOccurrences[1];
        }
        return numberOfOccurrences >= this.rangeOfOccurrences[0];
    }

    public String ranegAsString() {
        if (this.rangeOfOccurrences[1] > 0) {
            return ">= " + this.rangeOfOccurrences[0] + " and <= " + this.rangeOfOccurrences[1];
        }
        return ">= " + this.rangeOfOccurrences[0];
    }
}

