/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.settings.ContentType;
import edu.uml.lgdc.project.settings.OptionDesc;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.SectionDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ini4j.Config;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class OptionsIOini
implements OptionsIO {
    private final Map<String, SectionDescriptor<?>> optSecDescriptors;
    private Ini ini;
    private final boolean treatUnknownNamesAsError;
    private final File file;
    private boolean error;
    private transient Map<String, List<Map<String, String>>> changedNameOptions = new HashMap<String, List<Map<String, String>>>();
    private transient boolean optionsAcquired;

    public OptionsIOini(Map<String, SectionDescriptor<?>> optSecDescriptors, String fileName) {
        this(optSecDescriptors, fileName, true);
    }

    public OptionsIOini(Map<String, SectionDescriptor<?>> optSecDescriptors, String fileName, boolean treatUnknownnamesAsError) {
        this(optSecDescriptors, fileName, treatUnknownnamesAsError, false);
    }

    public OptionsIOini(Map<String, SectionDescriptor<?>> optSecDescriptors, String fileName, boolean treatUnknownNamesAsError, boolean noIniFileAbsentMsg) {
        File file;
        this.optSecDescriptors = optSecDescriptors;
        this.file = file = new File(fileName);
        this.treatUnknownNamesAsError = treatUnknownNamesAsError;
        this.ini = new Ini();
        Config config = new Config();
        config.setMultiSection(true);
        config.setMultiOption(true);
        this.ini.setConfig(config);
        if (!file.isFile()) {
            if (!noIniFileAbsentMsg) {
                Console.showMsg("ini-file \"" + file + "\" doesn't exist. Default values will be used.");
            }
        } else {
            try {
                this.ini.setFile(file);
                this.ini.load(file);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.checkNames()) {
            this.get();
        } else {
            this.error = true;
        }
    }

    public OptionsIOini(Map<String, SectionDescriptor<?>> optSecDescriptors, InputStream is) {
        this(optSecDescriptors, is, true);
    }

    public OptionsIOini(Map<String, SectionDescriptor<?>> optSecDescriptors, InputStream is, boolean treatUnknownNamesAsError) {
        this.optSecDescriptors = optSecDescriptors;
        this.ini = new Ini();
        this.file = null;
        this.treatUnknownNamesAsError = treatUnknownNamesAsError;
        Config config = new Config();
        config.setMultiSection(true);
        config.setMultiOption(true);
        this.ini.setConfig(config);
        try {
            this.ini.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.ini = new Ini();
        }
        if (this.checkNames()) {
            this.get();
        } else {
            this.error = true;
        }
    }

    public void reload() {
        block14: {
            if (this.file == null) {
                Console.showError("OptionsIO: failed request to reload options from a null file...");
                return;
            }
            if (this.ini == null) {
                Console.showError("OptionsIO: failed request to reload options using null ini...");
                return;
            }
            FileInputStream inputStream = null;
            try {
                try {
                    inputStream = new FileInputStream(this.file);
                    this.ini.load((InputStream)inputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (inputStream == null) break block14;
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    private boolean checkNames() {
        boolean noDuplication = this.checkForDuplication();
        boolean allNamesAreKnown = this.checkForUnknownName();
        if (noDuplication && (allNamesAreKnown || !this.treatUnknownNamesAsError) && this.addDefaultValues()) {
            if (!this.treatUnknownNamesAsError) {
                this.setValuesForRenamedOptions();
            }
            if (!allNamesAreKnown && this.file != null) {
                this.save();
            }
            this.changedNameOptions = null;
            return true;
        }
        Iterator iterSections = this.ini.keySet().iterator();
        while (iterSections.hasNext()) {
            iterSections.next();
            iterSections.remove();
        }
        return false;
    }

    public File getFile() {
        return this.ini.getFile();
    }

    private void get() {
        for (SectionDescriptor<?> settings : this.optSecDescriptors.values()) {
            if (settings.getDefaultValue() == null && !this.isSectionPresent(settings.getName())) continue;
            settings.getFrom(this);
        }
        this.optionsAcquired = true;
    }

    private void put() {
        for (SectionDescriptor<?> settings : this.optSecDescriptors.values()) {
            settings.putTo(this);
        }
    }

    @Override
    public SectionDescriptor<?> getSectionDescriptor(String sectionName) {
        return this.optSecDescriptors.get(sectionName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            OptionsIOini optionsIO = (OptionsIOini)obj;
            return this.optSecDescriptors.equals(optionsIO.optSecDescriptors) && this.ini.entrySet().equals(optionsIO.ini.entrySet());
        }
        return false;
    }

    public void fill(String sectionName, OptionsIOini other) {
        Profile.Section thisSection = (Profile.Section)this.ini.get((Object)sectionName);
        Profile.Section otherSection = (Profile.Section)other.ini.get((Object)sectionName);
        for (String optionName : otherSection.keySet()) {
            thisSection.put((Object)optionName, (Object)((String)otherSection.get((Object)optionName)));
        }
    }

    @Override
    public boolean isSectionPresent(String sectionName) {
        return this.ini.get((Object)sectionName) != null;
    }

    @Override
    public boolean isOptionPresent(String sectionName, String optionName) {
        Profile.Section section = (Profile.Section)this.ini.get((Object)sectionName);
        if (section != null) {
            return section.get((Object)optionName) != null;
        }
        throw new RuntimeException("Design error: section " + sectionName + " is not present");
    }

    @Override
    public Map<String, Map<String, String>> getSettingsByType(EnumSet<ContentType> sectionSelection, EnumSet<ContentType> optionSelection) {
        int sections = 0;
        int options = 0;
        if (sectionSelection != null) {
            for (ContentType section : sectionSelection) {
                sections += section.getId();
            }
        }
        if (optionSelection != null) {
            for (ContentType option : optionSelection) {
                options += option.getId();
            }
        }
        return this.getSettingsByType(sections, options);
    }

    @Override
    public Map<String, Map<String, String>> getSettingsByType(int sectionSelection, int optionSelection) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        Collection<SectionDescriptor<?>> optSecDescs = this.optSecDescriptors.values();
        for (SectionDescriptor<?> optSecDescriptor : optSecDescs) {
            Map<String, String> nameValPairs;
            if (sectionSelection != 0 && !optSecDescriptor.isIncluded(sectionSelection) || (nameValPairs = optSecDescriptor.getOptionsByType(this, optionSelection)).isEmpty()) continue;
            result.put(optSecDescriptor.getName(), nameValPairs);
        }
        return result;
    }

    private boolean checkForDuplication() {
        boolean noDuplication = true;
        for (String sectionName : this.ini.keySet()) {
            SectionDescriptor<?> optSecDescriptor = this.optSecDescriptors.get(sectionName);
            if (optSecDescriptor == null) continue;
            List sections = this.ini.getAll((Object)sectionName);
            if (!optSecDescriptor.isNumberOfOccurrencesIsInRange(sections.size())) {
                Console.showError("Section [" + sectionName + "] occured " + sections.size() + " times in ini-file" + ", but allowed range is " + optSecDescriptor.ranegAsString());
                Console.showError("Section [" + sectionName + "] is not multiple-section, but occurred more than once in ini-file.");
                noDuplication = false;
                continue;
            }
            Map<String, OptionDesc> options = optSecDescriptor.getOptionsDescriptor();
            int i = 0;
            while (i < sections.size()) {
                Profile.Section section = (Profile.Section)sections.get(i);
                for (String optionName : section.keySet()) {
                    int numberOfOccurrences;
                    OptionDesc optionDesc = options.get(optionName);
                    if (optionDesc == null || optionDesc.isNumberOfOccurrencesIsInRange(numberOfOccurrences = section.length((Object)optionName))) continue;
                    Console.showError("Option " + optionName + " of section [" + sectionName + "]" + (sections.size() == 1 ? "" : "(" + (i + 1) + ")") + " occured " + numberOfOccurrences + " times in ini-file\n  But allowed range is " + optionDesc.ranegAsString());
                    noDuplication = false;
                }
                ++i;
            }
        }
        return noDuplication;
    }

    private boolean checkForUnknownName() {
        boolean allNamesAreKnown = true;
        Iterator iterSections = this.ini.keySet().iterator();
        while (iterSections.hasNext()) {
            String sectionName = (String)iterSections.next();
            SectionDescriptor<?> optSecDescriptor = this.optSecDescriptors.get(sectionName);
            if (optSecDescriptor == null) {
                if (this.treatUnknownNamesAsError) {
                    Console.showError("Section [" + sectionName + "] found in ini-file is unknown.");
                } else {
                    Console.showWarn("Section [" + sectionName + "] found in ini-file is unknown, will be deleted.");
                }
                iterSections.remove();
                allNamesAreKnown = false;
                continue;
            }
            Map<String, OptionDesc> options = optSecDescriptor.getOptionsDescriptor();
            List sections = this.ini.getAll((Object)sectionName);
            if (!optSecDescriptor.isNumberOfOccurrencesIsInRange(sections.size())) continue;
            ArrayList sectionChangedNameOptions = new ArrayList(sections.size());
            boolean isChangedNameOption = false;
            int i = 0;
            while (i < sections.size()) {
                Profile.Section section = (Profile.Section)sections.get(i);
                HashMap<String, String> optionsName2ValueMap = new HashMap<String, String>();
                sectionChangedNameOptions.add(optionsName2ValueMap);
                Iterator iterOptions = section.keySet().iterator();
                while (iterOptions.hasNext()) {
                    String optionName = (String)iterOptions.next();
                    OptionDesc optionDesc = options.get(optionName);
                    if (optionDesc != null) continue;
                    if (!this.treatUnknownNamesAsError) {
                        String valueOfUnknownOptionName = (String)section.get((Object)optionName);
                        String[] newOptionNameValue = optSecDescriptor.optionRenameHook(optionName, valueOfUnknownOptionName);
                        if (newOptionNameValue == null) {
                            Console.showWarn("Option " + optionName + " of section [" + sectionName + "] found in ini-file is unknown, will be deleted.");
                        } else {
                            String msg = "The name of option " + optionName + " of section [" + sectionName + "] will be changed to " + newOptionNameValue[0];
                            if (!Objects.equals(valueOfUnknownOptionName, newOptionNameValue[1])) {
                                msg = String.valueOf(msg) + ", and value " + valueOfUnknownOptionName + " will be changed to " + newOptionNameValue[1];
                            }
                            Console.showWarn(msg);
                            isChangedNameOption = true;
                            optionsName2ValueMap.put(newOptionNameValue[0], newOptionNameValue[1]);
                        }
                    } else {
                        Console.showError("Option " + optionName + " of section [" + sectionName + "] found in ini-file is unknown");
                    }
                    iterOptions.remove();
                    allNamesAreKnown = false;
                }
                ++i;
            }
            if (!isChangedNameOption) continue;
            this.changedNameOptions.put(sectionName, sectionChangedNameOptions);
        }
        return allNamesAreKnown;
    }

    private boolean addDefaultValues() {
        boolean valuesAreSpecified = true;
        for (String sectionName : this.optSecDescriptors.keySet()) {
            List sections = this.ini.getAll((Object)sectionName);
            if (sections != null) {
                for (Profile.Section section : sections) {
                    if (this.addDefaultValuesForSection(section)) continue;
                    valuesAreSpecified = false;
                }
                continue;
            }
            if (this.addDefaultForMissedSection(sectionName)) continue;
            valuesAreSpecified = false;
        }
        return valuesAreSpecified;
    }

    private boolean addDefaultValuesForSection(Profile.Section section) {
        boolean valuesAreSpecified = true;
        SectionDescriptor<?> optSecDescriptor = this.optSecDescriptors.get(section.getName());
        Map<String, OptionDesc> optionsMap = optSecDescriptor.getOptionsDescriptor();
        for (String optionName : optionsMap.keySet()) {
            if (section.get((Object)optionName) != null) continue;
            OptionDesc optionDesc = optionsMap.get(optionName);
            Object defaultValueList = optionDesc.getDefaultValue();
            if (defaultValueList != null) {
                if (defaultValueList instanceof Object[]) {
                    Object[] list = (Object[])defaultValueList;
                    int i = 0;
                    while (i < list.length) {
                        section.put((Object)optionName, (Object)String.valueOf(list[i]), i);
                        ++i;
                    }
                    continue;
                }
                section.put((Object)optionName, (Object)String.valueOf(defaultValueList));
                continue;
            }
            int[] rangeOfOccurence = optionDesc.getRangeOfOccurrences();
            if (rangeOfOccurence[0] <= 0) continue;
            Console.showError("Section [" + section.getName() + "] option " + optionName + ": mandatory option is not specified");
            valuesAreSpecified = false;
        }
        return valuesAreSpecified;
    }

    private boolean addDefaultForMissedSection(String sectionName) {
        boolean valuesAreSpecified = true;
        SectionDescriptor<?> optSecDescriptor = this.optSecDescriptors.get(sectionName);
        if (optSecDescriptor.getDefaultValue() != null) {
            optSecDescriptor.putTo(this);
        } else {
            int[] rangeOfOccurence = optSecDescriptor.getRangeOfOccurrences();
            if (rangeOfOccurence[0] > 0) {
                Console.showError("Section [" + sectionName + "]: mandatory section is not specified");
                valuesAreSpecified = false;
            }
        }
        return valuesAreSpecified;
    }

    private void setValuesForRenamedOptions() {
        Set<String> keySet = this.changedNameOptions.keySet();
        for (String sectionName : keySet) {
            List<Map<String, String>> listOfMaps = this.changedNameOptions.get(sectionName);
            List sections = this.ini.getAll((Object)sectionName);
            int i = 0;
            while (i < listOfMaps.size()) {
                Map<String, String> optionValues = listOfMaps.get(i);
                if (!optionValues.isEmpty()) {
                    Profile.Section section = (Profile.Section)sections.get(i);
                    Set<String> optionKeySet = optionValues.keySet();
                    for (String optionName : optionKeySet) {
                        section.put((Object)optionName, (Object)optionValues.get(optionName));
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void save() {
        block12: {
            this.file.delete();
            FileOutputStream outputStream = null;
            try {
                try {
                    outputStream = new FileOutputStream(this.file);
                    this.save(outputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (outputStream == null) break block12;
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void save(OutputStream outputStream) {
        if (this.optionsAcquired) {
            this.put();
        }
        try {
            this.ini.store(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String get(String sectionName, String optionName) {
        Profile.Section section = (Profile.Section)this.ini.get((Object)sectionName);
        if (section == null) {
            throw new IllegalArgumentException("unknown section: " + sectionName);
        }
        if (!section.containsKey((Object)optionName)) {
            throw new IllegalArgumentException("unknown option " + optionName + " for section: " + sectionName);
        }
        return (String)section.get((Object)optionName);
    }

    @Override
    public Set<String> getAll(String sectionName) {
        Profile.Section section = (Profile.Section)this.ini.get((Object)sectionName);
        if (section == null) {
            throw new IllegalArgumentException("unknown section: " + sectionName);
        }
        return section.keySet();
    }

    @Override
    public void put(String sectionName, String optionName, String optionValue) {
        Map<String, OptionDesc> optionsDescMap = this.optSecDescriptors.get(sectionName).getOptionsDescriptor();
        if (optionsDescMap == null) {
            throw new IllegalArgumentException("unknown section name, " + sectionName);
        }
        OptionDesc optionDesc = optionsDescMap.get(optionName);
        if (optionDesc == null) {
            throw new IllegalArgumentException("unknown option " + optionName + ", for section name, " + sectionName);
        }
        Profile.Section section = (Profile.Section)this.ini.get((Object)sectionName);
        if (section == null) {
            this.ini.add(sectionName);
            section = (Profile.Section)this.ini.get((Object)sectionName);
        }
        section.put((Object)optionName, (Object)optionValue);
    }

    @Override
    public void removeSection(String sectionName) {
        this.ini.remove((Object)sectionName);
    }

    @Override
    public int getNumberOfMultipleSections(String sectionName) {
        return this.ini.length((Object)sectionName);
    }

    @Override
    public String get(String sectionName, String optionName, int index) {
        Profile.Section section = (Profile.Section)this.ini.get((Object)sectionName, index);
        if (section == null) {
            throw new IllegalArgumentException("unknown section: " + sectionName);
        }
        String optionValue = (String)section.get((Object)optionName);
        if (optionValue == null) {
            throw new IllegalArgumentException("unknown option " + optionName + " for section: " + sectionName);
        }
        return optionValue;
    }

    @Override
    public void put(String sectionName, String optionName, String optionValue, int index) {
        Map<String, OptionDesc> optionsDescMap = this.optSecDescriptors.get(sectionName).getOptionsDescriptor();
        if (optionsDescMap == null) {
            throw new IllegalArgumentException("unknown section name, " + sectionName);
        }
        OptionDesc optionDesc = optionsDescMap.get(optionName);
        if (optionDesc == null) {
            throw new IllegalArgumentException("unknown option " + optionName + ", for section name, " + sectionName);
        }
        Profile.Section section = (Profile.Section)this.ini.get((Object)sectionName, index);
        if (section == null) {
            this.ini.add((Object)sectionName, (Object)section, index);
            section = (Profile.Section)this.ini.get((Object)sectionName, index);
        }
        section.put((Object)optionName, (Object)optionValue);
    }

    @Override
    public boolean isError() {
        return this.error;
    }
}

