/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

import edu.uml.lgdc.fileio.PortablePath;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.math.BinaryMask;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.settings.ContentType;
import edu.uml.lgdc.project.settings.OptionDesc;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.SectionDescriptor;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class OutputFileSettings
extends SectionDescriptor<OutputFileSettings> {
    private static final String SECTION_NAME = "Output File Options";
    static final String DATA_PRODUCTS_SELECTION = "DataProductsSelection";
    static final String OUTGOING_FOLDER_FOR_DATA = "OutgoingFolder_ForData";
    static final String OUTGOING_FOLDER_FOR_ERROR_MESSAGES = "OutgoingFolder_ForErrorMessages";
    static final String SAVE_MEAS_AS_INDIVIDUAL_FILES = "SaveMeas_AsIndividualFiles";
    static final String SAVE_MEAS_OUTGOING_DATA_FOLDER = "SaveMeas_OutgoingFolder";
    static final String SAVE_MEAS_AS_DAY_FILES = "SaveMeas_AsDayFiles";
    static final String GROUP_DATA_BY_DAY_FOLDERS = "GroupData_ByDayFolders";
    static final String GROUP_DATA_BY_TYPE_FOLDERS = "GroupData_ByTypeFolders";
    static final String GROUP_DATA_BY_DAY_FIRST = "GroupData_ByDayFirst";
    static final String LOG_FILE_NAME = "LogFileName";
    static final String LOG_FILE_FOLDER = "LogFileFolder";
    static final String DEBUG_INFO_VERBOSE_LEVEL = "DebugInfo_VerboseLevel";
    protected int dataProductsSelection;
    private String outgoingDataFolder;
    private String outgoingFolderForErrorMessages;
    private boolean saveMeasAsIndividualFiles;
    private boolean saveMeasAsDayfiles;
    private boolean groupDataByDayFolders;
    private boolean groupDataByTypeFolders;
    private boolean groupDataByDayFirst;
    private String logFileName;
    private String logFileFolder;
    private int verboseLevel;
    protected final Map<String, OptionDesc> descriptor = new HashMap<String, OptionDesc>();

    public int getDataProductsSelection() {
        return this.dataProductsSelection;
    }

    public void setDataProductsSelection(int dataProductsSelection) {
        this.dataProductsSelection = dataProductsSelection;
    }

    public String getOutgoingDataFolder() {
        return this.outgoingDataFolder;
    }

    public void setOutgoingDataFolder(String outgoingDataFolder) {
        this.outgoingDataFolder = outgoingDataFolder;
    }

    public String getOutgoingFolderForErrorMessages() {
        return this.outgoingFolderForErrorMessages;
    }

    public void setOutgoingFolderForErrorMessages(String outgoingFolderForErrorMessages) {
        this.outgoingFolderForErrorMessages = outgoingFolderForErrorMessages;
    }

    public boolean isSaveMeasAsIndividualFiles() {
        return this.saveMeasAsIndividualFiles;
    }

    public void setSaveMeasAsIndividualFiles(boolean saveMeasAsIndividualFiles) {
        this.saveMeasAsIndividualFiles = saveMeasAsIndividualFiles;
    }

    public boolean isSaveMeasAsDayfiles() {
        return this.saveMeasAsDayfiles;
    }

    public void setSaveMeasAsDayfiles(boolean saveMeasAsDayfiles) {
        this.saveMeasAsDayfiles = saveMeasAsDayfiles;
    }

    public boolean isGroupDataByDayFolders() {
        return this.groupDataByDayFolders;
    }

    public void setGroupDataByDayFolders(boolean groupDataByDayFolders) {
        this.groupDataByDayFolders = groupDataByDayFolders;
    }

    public boolean isGroupDataByTypeFolders() {
        return this.groupDataByTypeFolders;
    }

    public void setGroupDataByTypeFolders(boolean groupDataByTypeFolders) {
        this.groupDataByTypeFolders = groupDataByTypeFolders;
    }

    public boolean isGroupDataByDayFirst() {
        return this.groupDataByDayFirst;
    }

    public void setGroupDataByDayFirst(boolean groupDataByDayFirst) {
        this.groupDataByDayFirst = groupDataByDayFirst;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public String getLogFileFolder() {
        return this.logFileFolder;
    }

    public void setLogFileFolder(String logFileFolder) {
        this.logFileFolder = logFileFolder;
    }

    public int getDebugInfoVerboseLevel() {
        return this.verboseLevel;
    }

    public void setDebugInfoVerboseLevel(int verboseLevel) {
        this.verboseLevel = verboseLevel;
    }

    public OutputFileSettings() {
        this.setDefaults();
        this.fillDescriptor();
    }

    protected void setDefaults() {
        this.dataProductsSelection = 0;
        this.outgoingDataFolder = "OutputFiles";
        this.outgoingFolderForErrorMessages = "ErrorMessages";
        this.saveMeasAsIndividualFiles = true;
        this.saveMeasAsDayfiles = false;
        this.groupDataByDayFolders = true;
        this.groupDataByTypeFolders = false;
        this.groupDataByDayFirst = true;
        this.logFileName = String.valueOf(CommonConst.getApplicationName()) + ".log";
        this.logFileFolder = new PortablePath(new File(CommonConst.getUserDir()), "log").getInternal();
        this.verboseLevel = 0;
    }

    @Override
    protected void fillDescriptor() {
        this.descriptor.put(DATA_PRODUCTS_SELECTION, new OptionDesc((Object)this.dataProductsSelection, ContentType.EXPORT));
        this.descriptor.put(OUTGOING_FOLDER_FOR_DATA, new OptionDesc((Object)this.outgoingDataFolder, ContentType.EXPORT));
        this.descriptor.put(OUTGOING_FOLDER_FOR_ERROR_MESSAGES, new OptionDesc((Object)this.outgoingFolderForErrorMessages, ContentType.EXPORT));
        this.descriptor.put(SAVE_MEAS_AS_INDIVIDUAL_FILES, new OptionDesc((Object)this.saveMeasAsIndividualFiles, ContentType.EXPORT));
        this.descriptor.put(SAVE_MEAS_AS_DAY_FILES, new OptionDesc((Object)this.saveMeasAsDayfiles, ContentType.EXPORT));
        this.descriptor.put(GROUP_DATA_BY_DAY_FOLDERS, new OptionDesc((Object)this.groupDataByDayFolders, ContentType.EXPORT));
        this.descriptor.put(GROUP_DATA_BY_TYPE_FOLDERS, new OptionDesc((Object)this.groupDataByTypeFolders, ContentType.EXPORT));
        this.descriptor.put(GROUP_DATA_BY_DAY_FIRST, new OptionDesc((Object)this.groupDataByDayFirst, ContentType.EXPORT));
        this.descriptor.put(LOG_FILE_NAME, new OptionDesc((Object)this.logFileName, ContentType.DEBUG));
        this.descriptor.put(LOG_FILE_FOLDER, new OptionDesc((Object)this.logFileFolder, ContentType.DEBUG));
        this.descriptor.put(DEBUG_INFO_VERBOSE_LEVEL, new OptionDesc((Object)this.verboseLevel, ContentType.DEBUG));
    }

    @Override
    public void getFrom(OptionsIO paramsIO) {
        String maskExpression = paramsIO.get(this.getName(), DATA_PRODUCTS_SELECTION);
        this.dataProductsSelection = Math.max(0, (int)BinaryMask.fromExpression(maskExpression));
        this.outgoingDataFolder = paramsIO.get(this.getName(), OUTGOING_FOLDER_FOR_DATA);
        this.outgoingFolderForErrorMessages = paramsIO.get(this.getName(), OUTGOING_FOLDER_FOR_ERROR_MESSAGES);
        this.saveMeasAsIndividualFiles = Boolean.valueOf(paramsIO.get(this.getName(), SAVE_MEAS_AS_INDIVIDUAL_FILES));
        this.outgoingDataFolder = paramsIO.get(this.getName(), SAVE_MEAS_OUTGOING_DATA_FOLDER);
        this.saveMeasAsDayfiles = Boolean.valueOf(paramsIO.get(this.getName(), SAVE_MEAS_AS_DAY_FILES));
        this.groupDataByDayFolders = Boolean.valueOf(paramsIO.get(this.getName(), GROUP_DATA_BY_DAY_FOLDERS));
        this.groupDataByTypeFolders = Boolean.valueOf(paramsIO.get(this.getName(), GROUP_DATA_BY_TYPE_FOLDERS));
        this.groupDataByDayFirst = Boolean.valueOf(paramsIO.get(this.getName(), GROUP_DATA_BY_DAY_FIRST));
        this.logFileName = paramsIO.get(this.getName(), LOG_FILE_NAME);
        this.logFileFolder = paramsIO.get(this.getName(), LOG_FILE_FOLDER);
        this.verboseLevel = Integer.valueOf(paramsIO.get(this.getName(), DEBUG_INFO_VERBOSE_LEVEL));
    }

    @Override
    public void putTo(OptionsIO paramsIO) {
        paramsIO.put(this.getName(), DATA_PRODUCTS_SELECTION, BinaryMask.toExpression(this.dataProductsSelection));
        paramsIO.put(this.getName(), OUTGOING_FOLDER_FOR_DATA, this.outgoingDataFolder);
        paramsIO.put(this.getName(), OUTGOING_FOLDER_FOR_ERROR_MESSAGES, this.outgoingFolderForErrorMessages);
        paramsIO.put(this.getName(), SAVE_MEAS_AS_INDIVIDUAL_FILES, Boolean.toString(this.saveMeasAsIndividualFiles));
        paramsIO.put(this.getName(), SAVE_MEAS_OUTGOING_DATA_FOLDER, this.outgoingDataFolder);
        paramsIO.put(this.getName(), SAVE_MEAS_AS_DAY_FILES, Boolean.toString(this.saveMeasAsDayfiles));
        paramsIO.put(this.getName(), GROUP_DATA_BY_DAY_FOLDERS, Boolean.toString(this.groupDataByDayFolders));
        paramsIO.put(this.getName(), GROUP_DATA_BY_TYPE_FOLDERS, Boolean.toString(this.groupDataByTypeFolders));
        paramsIO.put(this.getName(), GROUP_DATA_BY_DAY_FIRST, Boolean.toString(this.groupDataByDayFirst));
        paramsIO.put(this.getName(), LOG_FILE_NAME, this.logFileName);
        paramsIO.put(this.getName(), LOG_FILE_FOLDER, this.logFileFolder);
        paramsIO.put(this.getName(), DEBUG_INFO_VERBOSE_LEVEL, Integer.toString(this.verboseLevel));
    }

    public void set(OutputFileSettings input) {
        this.dataProductsSelection = input.dataProductsSelection;
        this.outgoingDataFolder = input.outgoingDataFolder;
        this.outgoingFolderForErrorMessages = input.outgoingFolderForErrorMessages;
        this.saveMeasAsIndividualFiles = input.saveMeasAsIndividualFiles;
        this.saveMeasAsDayfiles = input.saveMeasAsDayfiles;
        this.groupDataByDayFolders = input.groupDataByDayFolders;
        this.groupDataByTypeFolders = input.groupDataByTypeFolders;
        this.groupDataByDayFirst = input.groupDataByDayFirst;
        this.logFileName = input.logFileName;
        this.logFileFolder = input.logFileFolder;
        this.verboseLevel = input.verboseLevel;
    }

    public Object clone() {
        OutputFileSettings output = new OutputFileSettings();
        output.set(this);
        return output;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof OutputFileSettings) {
            OutputFileSettings o = (OutputFileSettings)obj;
            result = this.dataProductsSelection == o.dataProductsSelection && this.outgoingDataFolder == o.outgoingDataFolder && this.outgoingFolderForErrorMessages == o.outgoingFolderForErrorMessages && this.saveMeasAsIndividualFiles == o.saveMeasAsIndividualFiles && this.saveMeasAsDayfiles == o.saveMeasAsDayfiles && this.groupDataByDayFolders == o.groupDataByDayFolders && this.groupDataByTypeFolders == o.groupDataByTypeFolders && this.groupDataByDayFirst == o.groupDataByDayFirst && this.logFileName == o.logFileName && this.logFileFolder == o.logFileFolder && this.verboseLevel == o.verboseLevel;
        }
        return result;
    }

    @Override
    public OutputFileSettings getThis() {
        return this;
    }

    @Override
    public String getName() {
        return SECTION_NAME;
    }

    @Override
    public Map<String, OptionDesc> getOptionsDescriptor() {
        return this.descriptor;
    }

    @Override
    public String[] optionRenameHook(String unknowmParamName, String valueOfUnknownParamName) {
        return null;
    }

    public String getOutgoingDataFolder(TimeScale startTime, String dataType) {
        File file;
        if (startTime == null) {
            throw new IllegalArgumentException("startTime is null");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("dataType is null");
        }
        String outFolder = this.getOutgoingDataFolder();
        String timeFolder = null;
        if (this.isGroupDataByDayFolders()) {
            timeFolder = startTime.get(1) + FC.padLeft("" + (startTime.get(2) + 1), 2, '0') + FC.padLeft("" + startTime.get(5), 2, '0');
        }
        if (this.isGroupDataByDayFirst()) {
            if (this.isGroupDataByDayFolders()) {
                outFolder = String.valueOf(outFolder) + File.separator + timeFolder;
            }
            if (this.isGroupDataByTypeFolders()) {
                outFolder = String.valueOf(outFolder) + File.separator + dataType;
            }
        } else {
            if (this.isGroupDataByTypeFolders()) {
                outFolder = String.valueOf(outFolder) + File.separator + dataType;
            }
            if (this.isGroupDataByDayFirst()) {
                outFolder = String.valueOf(outFolder) + File.separator + timeFolder;
            }
        }
        if (!(file = new File(outFolder)).exists() && !file.mkdirs()) {
            Console.showError("Can't create directory " + outFolder);
        }
        return outFolder;
    }
}

