/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.settings.ContentType;
import edu.uml.lgdc.project.settings.FromStrHelper;
import edu.uml.lgdc.project.settings.OptionDesc;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.Settings;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class SectionDescriptor<E extends SectionDescriptor<?>>
implements Settings {
    protected final int INT_DONT_USE = Integer.MIN_VALUE;
    protected boolean parsingOrIllegalValueError;
    private int[] rangeOfOccurrences;
    private ContentType contentType;

    public SectionDescriptor() {
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.rangeOfOccurrences = nArray;
        this.contentType = ContentType.MIXED;
    }

    public abstract String getName();

    protected abstract void fillDescriptor();

    public abstract Map<String, OptionDesc> getOptionsDescriptor();

    public int[] getRangeOfOccurrences() {
        return this.rangeOfOccurrences;
    }

    public void setRangeOfOccurrences(int[] rangeOfOccurrences) {
        Objects.requireNonNull(rangeOfOccurrences);
        assert (rangeOfOccurrences.length == 2) : "range has to be array of 2 elements, but is " + rangeOfOccurrences.length;
        assert (rangeOfOccurrences[0] >= 0);
        assert (rangeOfOccurrences[1] >= 0);
        assert (rangeOfOccurrences[1] == 0 || rangeOfOccurrences[1] >= rangeOfOccurrences[0]);
        this.rangeOfOccurrences = rangeOfOccurrences;
    }

    public boolean isNumberOfOccurrencesIsInRange(int numberOfOccurrences) {
        if (this.rangeOfOccurrences[1] > 0) {
            return numberOfOccurrences >= this.rangeOfOccurrences[0] && numberOfOccurrences <= this.rangeOfOccurrences[1];
        }
        return numberOfOccurrences >= this.rangeOfOccurrences[0];
    }

    public String ranegAsString() {
        if (this.rangeOfOccurrences[1] > 0) {
            return ">= " + this.rangeOfOccurrences[0] + " and <= " + this.rangeOfOccurrences[1];
        }
        return ">= " + this.rangeOfOccurrences[0];
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public boolean isIncluded(int contentTypes) {
        return ContentType.isIncluded(this.contentType, contentTypes);
    }

    public boolean isIncluded(EnumSet contentTypes) {
        return ContentType.isIncluded(this.contentType, contentTypes);
    }

    public List<E> getDefaultValue() {
        if (this.rangeOfOccurrences[0] == 0 && this.rangeOfOccurrences[1] == 1) {
            ArrayList<E> list = new ArrayList<E>();
            list.add(this.getThis());
            return list;
        }
        return null;
    }

    public abstract E getThis();

    public boolean isParsingOrIllegalValueError() {
        return this.parsingOrIllegalValueError;
    }

    public String getErrMsg() {
        return null;
    }

    public String[] optionRenameHook(String unknowmOptionName, String valueOfUnknownOptionName) {
        return null;
    }

    public Map<String, String> getOptionsByType(OptionsIO optionsIO, int optionSelection) {
        this.putTo(optionsIO);
        Map<String, OptionDesc> descriptor = this.getOptionsDescriptor();
        HashMap<String, String> nameValPairs = new HashMap<String, String>();
        Set<String> optionNames = descriptor.keySet();
        for (String optionName : optionNames) {
            OptionDesc optionDesc = descriptor.get(optionName);
            if (!optionDesc.isIncluded(optionSelection)) continue;
            nameValPairs.put(optionName, optionsIO.get(this.getName(), optionName));
        }
        return nameValPairs;
    }

    protected int getStrictPositiveInt(OptionsIO optionsIO, String optionName) {
        FromStrHelper.Result result = FromStrHelper.getStrictPositiveInt(optionsIO.get(this.getName(), optionName));
        return this.checkIntResult(result, optionName, -1);
    }

    protected int getStrictPositiveInt(OptionsIO optionsIO, String optionName, int index) {
        FromStrHelper.Result result = FromStrHelper.getStrictPositiveInt(optionsIO.get(this.getName(), optionName, index));
        return this.checkIntResult(result, optionName, index);
    }

    protected int getPositiveInt(OptionsIO optionsIO, String optionName) {
        FromStrHelper.Result result = FromStrHelper.getPositiveInt(optionsIO.get(this.getName(), optionName));
        return this.checkIntResult(result, optionName, -1);
    }

    protected int getPositiveInt(OptionsIO optionsIO, String optionName, int index) {
        FromStrHelper.Result result = FromStrHelper.getPositiveInt(optionsIO.get(this.getName(), optionName, index));
        return this.checkIntResult(result, optionName, index);
    }

    private int checkIntResult(FromStrHelper.Result result, String optionName, int index) {
        if (result.errMsg == null) {
            if (!result.isDefaultValue) {
                return (Integer)result.value;
            }
            return Integer.MIN_VALUE;
        }
        this.parsingOrIllegalValueError = true;
        Console.showError("Section [" + this.getName() + "]" + (index >= 0 ? "(" + index + ")" : "") + " option " + optionName + ": " + result.errMsg);
        return Integer.MIN_VALUE;
    }

    protected String removeEnclosure(String str) {
        if (str != null && str.length() >= 2 && str.charAt(0) == '[' && str.charAt(str.length() - 1) == ']') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }
}

