/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

import edu.uml.lgdc.datatype.Cast;

public class Setting<T> {
    private T val;
    private boolean isSelected;
    private final SettingAttributes<T> attr;

    public Setting(T val, boolean isSelected, SettingAttributes<T> attr) {
        this.attr = attr;
        this.setVal(val);
        this.setSelected(isSelected);
    }

    public T getVal() {
        return this.val;
    }

    public T getValIfSelected() {
        if (this.isSelected) {
            return this.val;
        }
        return null;
    }

    private void setVal(T val) {
        if (val != null) {
            this.val = val;
            if (((SettingAttributes)this.attr).maxValue != null) {
                Object object = this.val = this.compareVal(((SettingAttributes)this.attr).maxValue) <= 0 ? val : ((SettingAttributes)this.attr).maxValue;
            }
            if (((SettingAttributes)this.attr).minValue != null) {
                this.val = this.compareVal(((SettingAttributes)this.attr).minValue) >= 0 ? val : ((SettingAttributes)this.attr).minValue;
            }
        }
    }

    public void setVal_o(Object val) {
        T valCast = Cast.cast(val, this.attr.getC());
        if (valCast != null) {
            this.setVal(valCast);
        }
    }

    public void setVal(String str) {
        if (!((SettingAttributes)this.attr).parseable) {
            System.out.println("Cannot parse class " + this.attr.getC().getName() + " from a string. Use direct set(T val).");
            return;
        }
        T val = this.val;
        val = Cast.cast(this.parse(str), this.attr.getC());
        this.setVal(val);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public SettingAttributes<T> getAttr() {
        return this.attr;
    }

    private Object parse(String str) {
        String cn = this.attr.getC().getName();
        try {
            if (cn.equals(Integer.class.getName())) {
                return Integer.parseInt(str);
            }
            if (cn.equals(Double.class.getName())) {
                return Double.parseDouble(str);
            }
            return str;
        }
        catch (NumberFormatException e) {
            System.out.println("Cannot parse class " + cn + " from \"" + str + "\". Set to previous valid value.");
            return null;
        }
    }

    private int compareVal(T val) {
        String cn = this.attr.getC().getName();
        if (cn.equals(Integer.class.getName())) {
            return Double.compare(((Integer)this.val).intValue(), ((Integer)val).intValue());
        }
        if (cn.equals(Double.class.getName())) {
            return Double.compare((Double)this.val, (Double)val);
        }
        return ((String)this.val).compareTo((String)val);
    }

    public static class SettingAttributes<T> {
        private final String label;
        private final Class<T> c;
        private final String description;
        private final boolean isSelectable;
        private final boolean hasValue;
        private final T minValue;
        private final T maxValue;
        private final boolean parseable;

        public SettingAttributes(String label, Class<T> c, String description, boolean isSelectable, boolean hasValue, T min, T max) {
            this.parseable = SettingAttributes.checkClassForParse(c.getName());
            this.label = label;
            this.c = c;
            this.description = description;
            this.isSelectable = isSelectable;
            this.hasValue = hasValue;
            this.minValue = min;
            this.maxValue = max;
        }

        public SettingAttributes(String label, Class<T> c, String description, boolean isSelectable, boolean hasValue) {
            this(label, c, description, isSelectable, hasValue, null, null);
        }

        public boolean isSelectable() {
            return this.isSelectable;
        }

        public String getLabel() {
            return this.label;
        }

        public Class<T> getC() {
            return this.c;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isHasValue() {
            return this.hasValue;
        }

        public T getMinValue() {
            return this.minValue;
        }

        public T getMaxValue() {
            return this.maxValue;
        }

        public static boolean checkClassForParse(String className) {
            return className.equals(Integer.class.getName()) || className.equals(Double.class.getName()) || className.equals(String.class.getName());
        }
    }
}

