/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.quantities;

import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.quantities.MeasureCat;
import edu.uml.lgdc.quantities.Qy;

public abstract class Units {
    private String name;
    private MeasureCat category;
    private double factor = 1.0;

    protected Units(String name, MeasureCat category, double factor) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (category == null) {
            throw new IllegalArgumentException("category == null");
        }
        if (factor <= 0.0) {
            throw new IllegalArgumentException("factor should be greater than 0");
        }
        this.name = name;
        this.category = category;
        this.factor = factor;
    }

    protected static Units getUnits(String name, MeasureCat category, double factor) {
        Units units = category.getUnits(name);
        if (units != null && units.getFactor() != factor) {
            throw new IllegalArgumentException("units " + name + " already registered with different factor");
        }
        return units;
    }

    public String getName() {
        return this.name;
    }

    public String getHumanName() {
        return this.name;
    }

    public String getNameForBrowser() {
        return this.name;
    }

    public MeasureCat getCategory() {
        return this.category;
    }

    public double getFactor() {
        return this.factor;
    }

    public double convert(double value, Units units) {
        return this.qy(value).get(units);
    }

    public String getCatName() {
        return this.category.getName();
    }

    public boolean isComparable(Units units) {
        return this.getCatName().equals(units.getCatName());
    }

    public abstract Qy<? extends Units> qy(double var1);

    public String getNameSq() {
        return "[" + this.name + "]";
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Units)) {
            return false;
        }
        return this.name.equals(((Units)object).name);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static String getValInOtherUnitsAsStr(Units units, int decimals, Units otherUnits, double valInOtherUnits) {
        Qy<? extends Units> smallest_qy_in_units = units.qy(1.0 / Math.pow(10.0, decimals));
        int times_in_one_otherUnit = (int)Math.round(1.0 / smallest_qy_in_units.get(otherUnits));
        int decimalsForOtherUnits = 0;
        while (times_in_one_otherUnit > 1) {
            times_in_one_otherUnit /= 10;
            ++decimalsForOtherUnits;
        }
        if (decimalsForOtherUnits == 0) {
            return "" + (int)Math.round(valInOtherUnits);
        }
        return Formatter.format("%." + decimalsForOtherUnits + "f", valInOtherUnits);
    }

    protected static String getEffectiveName(String name, int multiplier) {
        Units.checkMultiplier(multiplier);
        if (multiplier != 1) {
            return String.valueOf(multiplier) + name;
        }
        return name;
    }

    protected static double getEffectiveFactor(double factor, int multiplier) {
        Units.checkMultiplier(multiplier);
        if (multiplier != 1) {
            return factor / (double)multiplier;
        }
        return factor;
    }

    protected static void checkMultiplier(int multiplier) {
        if (multiplier <= 0) {
            throw new IllegalArgumentException("multiplier should be positive, " + multiplier);
        }
    }
}

