/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.radio;

import edu.uml.lgdc.geospace.Layer;
import edu.uml.lgdc.radio.Polarization;

public enum PropagationMode {
    O1F2L("F2L", Layer.F2, Polarization.ORDINARY, 1, true),
    O1F2H("F2H", Layer.F2, Polarization.ORDINARY, 1, false),
    X1F2L("F2L(x)", Layer.F2, Polarization.EXTRAORDINARY, 1, true),
    X1F2H("F2H(x)", Layer.F2, Polarization.EXTRAORDINARY, 1, false),
    O1F1L("F1L", Layer.F1, Polarization.ORDINARY, 1, true),
    O1F1H("F1H", Layer.F1, Polarization.ORDINARY, 1, false),
    X1F1L("F1L(x)", Layer.F1, Polarization.EXTRAORDINARY, 1, true),
    X1F1H("F1L(x)", Layer.F1, Polarization.EXTRAORDINARY, 1, false),
    O1EL("EL", Layer.E, Polarization.ORDINARY, 1, true),
    O1EH("EH", Layer.E, Polarization.ORDINARY, 1, false),
    X1EL("EL(x)", Layer.E, Polarization.EXTRAORDINARY, 1, true),
    X1EH("EH", Layer.E, Polarization.EXTRAORDINARY, 1, false);

    private final String name;
    private final Layer layer;
    private final Polarization rayPol;
    private final int hops;
    private final boolean lowPath;

    private PropagationMode(String name, Layer layer, Polarization rayPol, int hops, boolean lowPath) {
        this.name = name;
        this.layer = layer;
        this.rayPol = rayPol;
        this.hops = hops;
        this.lowPath = lowPath;
    }

    public String getName() {
        return this.name;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public Polarization getPolarization() {
        return this.rayPol;
    }

    public int getHops() {
        return this.hops;
    }

    public boolean isLowPath() {
        return this.lowPath;
    }
}

