/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.radio;

import edu.uml.lgdc.geospace.Layer;
import edu.uml.lgdc.radio.Polarization;
import java.util.List;

public class PropagationModeExtended {
    public static final int LOW_ELEVATION = 0;
    public static final int HIGH_ELEVATION = 1;
    public static final int UNKNOWN_ELEVATION = -1;
    Polarization polarization;
    List<HopName> hopNames;

    public PropagationModeExtended(Polarization pol, List<HopName> hopNames) {
        this.polarization = pol;
        this.hopNames = hopNames;
    }

    public String getLabel() {
        String label = String.valueOf(("" + this.polarization.getSymbol()).toLowerCase()) + ")";
        for (HopName hopName : this.hopNames) {
            label = String.valueOf(label) + (Object)((Object)hopName) + "+";
        }
        label = label.substring(0, label.length() - 1);
        return label;
    }

    public List<HopName> getHopNames() {
        return this.hopNames;
    }

    public Polarization getPolarization() {
        return this.polarization;
    }

    public boolean isUnknown() {
        return this.hopNames.get(0) == HopName.UNKNOWN;
    }

    public boolean equals(Object o) {
        PropagationModeExtended otherMode = (PropagationModeExtended)o;
        if (otherMode.getPolarization() != this.polarization) {
            return false;
        }
        if (otherMode.getHopNames().size() != this.hopNames.size()) {
            return false;
        }
        int i = 0;
        while (i < this.hopNames.size()) {
            if (otherMode.getHopNames().get(i) != this.hopNames.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static enum HopName {
        F2L("F2L", Layer.F2, 0),
        F2H("F2H", Layer.F2, 1),
        F1L("F1L", Layer.F1, 0),
        F1H("F1H", Layer.F1, 1),
        EL("EL", Layer.E, 0),
        EH("EH", Layer.E, 1),
        ESL("ESL", Layer.ES, 0),
        ESH("ESH", Layer.ES, 1),
        UNKNOWN("UNK", Layer.UNKNOWN, -1);

        private final String name;
        private final Layer layer;
        private final int elevation;

        private HopName(String name, Layer layer, int elevation) {
            this.name = name;
            this.layer = layer;
            this.elevation = elevation;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public int getElevation() {
            return this.elevation;
        }

        public String getName() {
            return this.name;
        }

        public Layer getLayerFromName(String name) {
            if (name == null) {
                System.err.println("Attempt to recognizer Layer in a null HopName");
                return null;
            }
            String layerName = name.substring(0, name.length() - 1);
            return Layer.getBySymbol(layerName);
        }

        public int getElevationFromName(String name) {
            if (name == null) {
                System.err.println("Attempt to recognizer Elevation type in a null HopName");
                return -1;
            }
            return name.endsWith("L") ? 0 : 1;
        }

        public boolean isHighElevation() {
            return this.elevation == 1;
        }

        public static HopName getFromName(String name) {
            HopName[] hopNameArray = HopName.values();
            int n = hopNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                HopName hopName = hopNameArray[n2];
                if (hopName.getName().equals(name)) {
                    return hopName;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public static HopName getFromLayerElevation(Layer layer, boolean highElevation) {
            switch (layer) {
                case F2: {
                    return highElevation ? F2H : F2L;
                }
                case F1: {
                    return highElevation ? F1H : F1L;
                }
                case ES: {
                    return highElevation ? ESH : ESL;
                }
                case E: {
                    return highElevation ? EH : EL;
                }
            }
            return UNKNOWN;
        }
    }
}

