/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.radio;

import edu.uml.lgdc.instrument.Platform;
import edu.uml.lgdc.instrument.StationLink;
import edu.uml.lgdc.radio.Polarization;

public class RadioPath
extends StationLink {
    private final double freq_kHz;
    private final Polarization pol;
    private transient int hash;

    public RadioPath(Platform rx, Platform tx, double freq_kHz, Polarization pol) {
        super(rx, tx.getAsRFTransmitter());
        this.freq_kHz = freq_kHz;
        this.pol = pol;
    }

    public double getFrequency_kHz() {
        return this.freq_kHz;
    }

    public Polarization getPolarization() {
        return this.pol;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getRxCode()) + "<--" + this.getTxCode() + " at " + this.freq_kHz + " kHz (" + this.pol.getSymbol() + ")";
    }

    @Override
    public int compareTo(StationLink stationLink) {
        if (!(stationLink instanceof RadioPath)) {
            throw new IllegalArgumentException("argument stationLink has to be of type " + RadioPath.class.getClass().getName());
        }
        int comp = super.compareTo(stationLink);
        if (comp != 0) {
            return comp;
        }
        RadioPath radioPath = (RadioPath)stationLink;
        comp = this.pol.compareTo(radioPath.pol);
        if (comp != 0) {
            return comp;
        }
        return (int)Math.signum(RadioPath.toHz(this.freq_kHz) - RadioPath.toHz(radioPath.freq_kHz));
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (this != obj) {
                RadioPath rp = (RadioPath)obj;
                return this.pol == rp.pol && RadioPath.toHz(this.freq_kHz) == RadioPath.toHz(rp.freq_kHz);
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = super.hashCode();
            h = 31 * h + this.pol.hashCode();
            this.hash = h = 31 * h + (int)Math.rint(1000.0 * this.freq_kHz);
        }
        return h;
    }

    private static int toHz(double f_kHz) {
        return (int)Math.rint(1000.0 * f_kHz);
    }
}

