/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.radio;

import edu.uml.lgdc.math.ExtMath;

public class SKYSource
implements Cloneable {
    public static final double NORMALIZED_PROJ_RADIUS = 20.0;
    private final double zenith_deg;
    private double azimuth_deg;
    private final int dopNumber;
    private final double amplitude_lin;
    private final double fitErr_deg;
    private final transient double amplitude_dB;

    public SKYSource(double zenith_deg, double azimuth_deg, double amplitude_lin, int dopNumber, double fitErr_deg) {
        if (zenith_deg < 0.0) {
            throw new IllegalArgumentException("negative zenith, " + zenith_deg);
        }
        if (zenith_deg >= 90.0) {
            throw new IllegalArgumentException("zenith > 90 deg, " + zenith_deg);
        }
        if (azimuth_deg < 0.0) {
            throw new IllegalArgumentException("negative azimuth, " + azimuth_deg);
        }
        if (azimuth_deg >= 360.0) {
            throw new IllegalArgumentException("azimuth >= 360, " + azimuth_deg);
        }
        if (amplitude_lin < 0.0) {
            throw new IllegalArgumentException("negative amplitude, " + amplitude_lin);
        }
        if (fitErr_deg < 0.0) {
            throw new IllegalArgumentException("negative fitErr_deg, " + fitErr_deg);
        }
        this.zenith_deg = zenith_deg;
        this.azimuth_deg = azimuth_deg;
        this.amplitude_lin = amplitude_lin;
        this.dopNumber = dopNumber;
        this.fitErr_deg = fitErr_deg;
        this.amplitude_dB = Math.max(ExtMath.linToDb(amplitude_lin), 0.0);
    }

    public double getZenith_deg() {
        return this.zenith_deg;
    }

    public double getAzimuth_deg() {
        return this.azimuth_deg;
    }

    public double getAmp_lin() {
        return this.amplitude_lin;
    }

    public double getAmp_dB() {
        return this.amplitude_dB;
    }

    public int getDopNumber() {
        return this.dopNumber;
    }

    public double getFitErr_deg() {
        return this.fitErr_deg;
    }

    public void rotate(double angle_deg) {
        this.azimuth_deg += angle_deg;
        if (this.azimuth_deg >= 360.0) {
            this.azimuth_deg -= 360.0;
        } else if (this.azimuth_deg < 0.0) {
            this.azimuth_deg += 360.0;
        }
    }

    public Object clone() {
        try {
            return (SKYSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public double getX(double maxZenith_deg) {
        double normRadius = Math.abs(20.0 / Math.sin(Math.toRadians(maxZenith_deg)));
        double sinZen = Math.abs(Math.sin(Math.toRadians(this.zenith_deg)));
        double cosAz = Math.cos(Math.toRadians(this.azimuth_deg));
        return normRadius * sinZen * cosAz;
    }

    public double getY(double maxZenith_deg) {
        double normRadius = Math.abs(20.0 / Math.sin(Math.toRadians(maxZenith_deg)));
        double sinZen = Math.abs(Math.sin(Math.toRadians(this.zenith_deg)));
        double sinAz = Math.sin(Math.toRadians(this.azimuth_deg));
        return normRadius * sinZen * sinAz;
    }

    public static double calcAzimuth_deg(double x, double y) {
        double phi = Math.toDegrees(Math.atan2(y, x));
        if (phi < 0.0) {
            phi += 360.0;
        }
        if (phi >= 360.0) {
            phi = 0.0;
        }
        return phi;
    }

    public static double calcZenith_deg(double x, double y, double maxZenith_deg) {
        double normRadius = Math.abs(20.0 / Math.sin(Math.toRadians(maxZenith_deg)));
        return Math.toDegrees(Math.asin(Math.hypot(x, y) / normRadius));
    }
}

