/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.radio;

import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.instrument.constants.TxMode;
import edu.uml.lgdc.radio.SkymapPoint;
import edu.uml.lgdc.time.TimeScale;

public class Signal
extends SkymapPoint {
    private static final String STANDARD_EXPORT_COLUMN_HEADER = "##       Date     Time" + Formatter.padLeft("path_km", 9) + Formatter.padLeft("dopp_Hz", 9) + Formatter.padLeft("zen_deg", 9) + Formatter.padLeft("azim_deg", 10);
    private static final String FULL_EXPORT_COLUMN_HEADER = String.valueOf(STANDARD_EXPORT_COLUMN_HEADER) + Formatter.padLeft("SNR_dB", 8) + Formatter.padLeft("Err_deg", 8) + Formatter.padLeft("Amp_dB", 8);
    private final boolean interpolated;
    private final int pointCount;
    protected final double dopplerShiftMin_Hz;
    protected final double dopplerShiftMax_Hz;

    public Signal(Signal sig) {
        this(sig.time, sig.freq_kHz, sig.range_km, sig.zenith_deg, sig.azimuth_deg, sig.dopplerShift_Hz, sig.dopplerShiftMin_Hz, sig.dopplerShiftMax_Hz, sig.fitErr_deg, sig.amplitude_dB, sig.snr_dB, sig.txMode, sig.interpolated, sig.pointCount);
    }

    public Signal(TimeScale time, double centerFreq_kHz, double range_km, double zenith_deg, double azimuth_deg, double dopplerShift_Hz, double dopplerShiftMin_Hz, double dopplerShiftMax_Hz, double fitErr_deg, double amplitude_dB, double snr_dB, TxMode txMode, boolean interpolated, int pointCount) {
        super(time, centerFreq_kHz, range_km, zenith_deg, azimuth_deg, dopplerShift_Hz, fitErr_deg, amplitude_dB, snr_dB, null, txMode);
        this.interpolated = interpolated;
        this.pointCount = pointCount;
        this.dopplerShiftMin_Hz = dopplerShiftMin_Hz;
        this.dopplerShiftMax_Hz = dopplerShiftMax_Hz;
    }

    @Override
    public double[] getAntennaPhases() {
        throw new RuntimeException("illegal call for class " + this.getClass().getSimpleName());
    }

    public boolean isInterpolated() {
        return this.interpolated;
    }

    public static String getStandardExportColumnHeader() {
        return STANDARD_EXPORT_COLUMN_HEADER;
    }

    public static String getFullExportColumnHeader() {
        return FULL_EXPORT_COLUMN_HEADER;
    }

    public String standartExport() {
        return String.valueOf(this.getTime().toFormatUT("YYYY.MM.dd,HH:mm:ss,")) + Formatter.format("%8.1f,%8.3f,%8.2f,%9.2f", this.getPathOrRange_km(), this.getDopplerShift_Hz(), this.getZenith_deg(), this.getAzimuth_deg());
    }

    public String fullExport() {
        return String.valueOf(this.getTime().toFormatUT("YYYY.MM.dd,HH:mm:ss,")) + Formatter.format("%8.1f,%8.3f,%8.2f,%9.2f,%7.1f,%7.1f,%7.1f", this.getPathOrRange_km(), this.getDopplerShift_Hz(), this.getZenith_deg(), this.getAzimuth_deg(), this.getSNR_dB(), this.getFitErr_deg(), this.getAmplitude_dB());
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.interpolated == ((Signal)object).interpolated;
    }

    @Override
    public int hashCode() {
        return 31 * (this.interpolated ? 0 : 1) + super.hashCode();
    }

    @Override
    public String toString() {
        return this.standartExport();
    }

    public int getPointCount() {
        return this.pointCount;
    }

    public boolean getInterpolated() {
        return this.interpolated;
    }

    public double getDopplerShiftMin_Hz() {
        return this.dopplerShiftMin_Hz;
    }

    public double getDopplerShiftMax_Hz() {
        return this.dopplerShiftMax_Hz;
    }
}

