/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.security;

import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.security.UserPass;

public class UserPassRole
extends UserPass {
    private static final UserPassRole EMPTY = new UserPassRole();
    private static final String ERR_MSG_ILLEGAL_SYMBOLS_IN_ROLE = "Only alphanumeric or underscore (_) characters are allowed in user name";
    private final String role;

    public UserPassRole(String user, char[] pass, String role) {
        super(user, pass);
        if (role != null && role.matches(".*[^\\w].*")) {
            throw new IllegalArgumentException(ERR_MSG_ILLEGAL_SYMBOLS_IN_ROLE);
        }
        this.role = role;
    }

    private UserPassRole() {
        this.role = null;
    }

    public String getRole() {
        return this.role;
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public String toString() {
        String str = super.toString();
        if (this.role != null) {
            if (this.getPass() == null) {
                str = String.valueOf(str) + 68;
            }
            str = String.valueOf(str) + '\"' + this.role + '\"';
        }
        return str;
    }

    public static UserPassRole parse(String str) {
        UserPass userPass;
        if (str == null || str.isEmpty()) {
            return EMPTY;
        }
        String role = null;
        int pos = str.indexOf(34);
        if (pos >= 0) {
            if (pos == str.length() - 1 || str.charAt(str.length() - 1) != '\"') {
                Console.showError("illegal user/pass string");
                return EMPTY;
            }
            int pos1 = str.lastIndexOf(34, str.length() - 2);
            if (pos1 > pos) {
                role = str.substring(pos1 + 1, str.length() - 1);
                str = str.substring(0, pos1);
            }
        }
        if (!(userPass = UserPass.parse(str)).isEmpty()) {
            return new UserPassRole(userPass.getUser(), userPass.getPass(), role);
        }
        return EMPTY;
    }

    public static UserPassRole getEmptyInstance() {
        return EMPTY;
    }
}

