/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.sftpjsch;

import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import edu.uml.lgdc.project.Console;
import java.util.Objects;

class NotInteractiveUserInfo
implements UserInfo,
UIKeyboardInteractive {
    private final char[] passwd;
    private boolean acceptUnknownHost;

    NotInteractiveUserInfo(char[] passwd) {
        this.passwd = Objects.requireNonNull(passwd);
    }

    public void setAcceptUnknownHost(boolean acceptUnknownHost) {
        this.acceptUnknownHost = acceptUnknownHost;
    }

    public String getPassword() {
        return new String(this.passwd);
    }

    public boolean promptYesNo(String str) {
        if (!this.acceptUnknownHost) {
            Console.showWarn(String.valueOf(str) + "\nNo");
            return false;
        }
        Console.showWarn(String.valueOf(str) + "\nYes");
        return true;
    }

    public String getPassphrase() {
        return null;
    }

    public boolean promptPassphrase(String message) {
        return true;
    }

    public boolean promptPassword(String message) {
        return true;
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        return new String[]{this.getPassword()};
    }

    public void showMessage(String message) {
        Console.showMsg(message);
    }
}

