/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.step;

import edu.uml.lgdc.project.CommonControl_Ix;
import edu.uml.lgdc.project.constants.StatusCode;
import edu.uml.lgdc.project.settings.StrictProperties;
import edu.uml.lgdc.step.StepContent_Ix;
import java.awt.Frame;
import java.awt.Graphics;

public abstract class RecognitionStep
implements CommonControl_Ix {
    protected StepContent_Ix inputContent;
    protected StepContent_Ix outputContent;
    protected StepContent_Ix subPixelContent;
    protected boolean batchMode = false;
    protected boolean consoleMode = false;
    protected boolean substepMode = false;
    protected boolean verboseOption = false;
    protected boolean tuneParametersEnabled = false;
    public Frame hostFrame;
    public String hostName = "";
    public int substepNumber = 0;

    @Override
    public void setStepMode(boolean b) {
    }

    @Override
    public void setSubstepMode(boolean b) {
        this.substepMode = b;
    }

    public RecognitionStep() {
        this.reset();
    }

    public abstract String getStepShortName();

    public abstract String getStepFullName();

    public abstract String getInputContentClassName();

    public abstract String getOutputContentClassName();

    public abstract StatusCode nextSubstep();

    @Override
    public void run() {
        this.startOver();
        while (this.nextSubstep() == StatusCode.CONTINUE) {
        }
    }

    public RecognitionStep(StepContent_Ix inputContent, StepContent_Ix outputContent) {
        this(inputContent, outputContent, null);
    }

    public RecognitionStep(StepContent_Ix inputContent, StepContent_Ix outputContent, StepContent_Ix subPixelContent) {
        this.reset();
        this.initContent(inputContent, outputContent, subPixelContent);
    }

    public void initContent(StepContent_Ix inputContent, StepContent_Ix outputContent) {
        this.inputContent = inputContent;
        this.outputContent = outputContent;
    }

    public void initContent(StepContent_Ix inputContent, StepContent_Ix outputContent, StepContent_Ix subPixelContent) {
        this.initContent(inputContent, outputContent);
        this.subPixelContent = subPixelContent;
    }

    public void reset() {
        this.inputContent = null;
        this.outputContent = null;
        this.subPixelContent = null;
        this.startOver();
    }

    @Override
    public void startOver() {
        this.substepNumber = 0;
    }

    public void readProperties(String propertiesString) {
        StrictProperties properties = new StrictProperties();
        properties.load(propertiesString);
        this.readAlgorithmParameters(properties);
    }

    public String writeProperties() {
        StrictProperties properties = this.writeAlgorithmParameters();
        return properties.getPropertiesString();
    }

    public StepContent_Ix getInputContent() {
        return this.inputContent;
    }

    public void setInputContent(StepContent_Ix content) {
        this.inputContent = content;
    }

    public StepContent_Ix getOutputContent() {
        return this.outputContent;
    }

    public void setOutputContent(StepContent_Ix content) {
        this.outputContent = content;
    }

    public StepContent_Ix getSubPixelContent() {
        return this.subPixelContent;
    }

    public void setSubPixelContent(StepContent_Ix subPixelContent) {
        this.subPixelContent = subPixelContent;
    }

    private static boolean isTheSameContent(String firstContent, String secondContent) {
        return firstContent.equals(secondContent);
    }

    public boolean isCompatibleInput(String content) {
        return RecognitionStep.isTheSameContent(content, this.getInputContentClassName());
    }

    public boolean isCompatibleOutput(String content) {
        return RecognitionStep.isTheSameContent(content, this.getOutputContentClassName());
    }

    @Override
    public void setBatchMode(boolean flag) {
        this.batchMode = flag;
    }

    @Override
    public void setConsoleMode(boolean flag) {
        this.consoleMode = flag;
    }

    public void setSteppingMode(boolean flag) {
        this.substepMode = flag;
    }

    @Override
    public void setVerboseOption(boolean flag) {
        this.verboseOption = flag;
    }

    @Override
    public void setHostFrame(Frame frame) {
        this.hostFrame = frame;
    }

    @Override
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setGraphics(Graphics g) {
    }

    @Override
    public String getName() {
        return this.getStepShortName();
    }

    @Override
    public String getParamDesc() {
        return null;
    }

    @Override
    public String description() {
        return this.getStepFullName();
    }

    public boolean isTuneParametersEnabled() {
        return this.tuneParametersEnabled;
    }

    public static RecognitionStep createRecognitionStep(String className) {
        RecognitionStep step = null;
        Class<?> tmpClass = null;
        try {
            tmpClass = Class.forName(className.trim());
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class '" + className + "' not found.");
            e.printStackTrace();
            return step;
        }
        try {
            step = (RecognitionStep)tmpClass.newInstance();
        }
        catch (IllegalAccessException e) {
            System.out.println("Access to class '" + className + "' denied.");
            e.printStackTrace();
            return step;
        }
        catch (InstantiationException e) {
            System.out.println("Cannot create instance of class '" + className + "'.");
            e.printStackTrace();
            return step;
        }
        return step;
    }

    @Override
    public void readAlgorithmParameters(StrictProperties strictProperties) {
    }

    @Override
    public void tuneParametersManually() {
    }

    @Override
    public StrictProperties writeAlgorithmParameters() {
        return new StrictProperties();
    }
}

