/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.step;

import edu.uml.lgdc.project.CommonControl_Ix;
import edu.uml.lgdc.project.constants.StatusCode;
import edu.uml.lgdc.project.settings.StrictProperties;
import edu.uml.lgdc.step.RecognitionStep;
import edu.uml.lgdc.step.StepContent_Ix;
import java.awt.Frame;

public abstract class RecognitionStepList
implements CommonControl_Ix {
    public static final String TAG_RS_LIST = "selRS";
    public static final String TAG_RS_LIST_OPTIONS = "selRsProp";
    protected StepContent_Ix listInputContent;
    protected StepContent_Ix listOutputContent;
    protected StepContent_Ix subPixelContent;
    protected String hostName = "";
    protected boolean batchMode = false;
    protected boolean consoleMode = false;
    protected boolean stepMode = false;
    protected boolean substepMode = false;
    protected boolean verboseOption = false;
    public Frame hostFrame;
    public String[] selectedRsNames;
    public String[] selectedRsPropertyStrings;
    protected RecognitionStep[] selectedRsObj;
    protected RecognitionStep step;
    private StatusCode completionStatus = StatusCode.OUT_OF_SEQUENCE;
    private int stepNumber = 0;
    private boolean newStep = true;
    private String prefix = "";

    public StepContent_Ix getInputContent() {
        return this.listInputContent;
    }

    public void setInputContent(StepContent_Ix content) {
        this.listInputContent = content;
    }

    public StepContent_Ix getOutputContent() {
        return this.listOutputContent;
    }

    public void setOutputContent(StepContent_Ix content) {
        this.listOutputContent = content;
    }

    public StepContent_Ix getSubPixelContent() {
        return this.subPixelContent;
    }

    public void setSubPixelContent(StepContent_Ix content) {
        this.subPixelContent = content;
    }

    public abstract String getInputContentClassName();

    public abstract String getOutputContentClassName();

    private static boolean isTheSameContent(String firstContent, String secondContent) {
        return firstContent.equals(secondContent);
    }

    public boolean isCompatibleInput(String content) {
        return RecognitionStepList.isTheSameContent(content, this.getInputContentClassName());
    }

    public boolean isCompatibleOutput(String content) {
        return RecognitionStepList.isTheSameContent(content, this.getOutputContentClassName());
    }

    @Override
    public void setBatchMode(boolean flag) {
        this.batchMode = flag;
    }

    @Override
    public void setConsoleMode(boolean flag) {
        this.consoleMode = flag;
    }

    @Override
    public void setStepMode(boolean flag) {
        this.stepMode = flag;
    }

    @Override
    public void setSubstepMode(boolean flag) {
        this.substepMode = flag;
    }

    @Override
    public void setVerboseOption(boolean flag) {
        this.verboseOption = flag;
    }

    @Override
    public void setHostFrame(Frame frame) {
        this.hostFrame = frame;
    }

    @Override
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public String getName() {
        return this.step == null ? "unknown" : this.step.getStepShortName();
    }

    @Override
    public String description() {
        return this.step == null ? "unknown" : this.step.getStepFullName();
    }

    @Override
    public void readAlgorithmParameters(StrictProperties properties) {
        this.selectedRsNames = properties.get(String.valueOf(this.prefix) + TAG_RS_LIST, this.selectedRsNames);
        this.selectedRsPropertyStrings = new String[this.selectedRsNames.length];
        int i = 0;
        while (i < this.selectedRsNames.length) {
            this.selectedRsPropertyStrings[i] = "";
            ++i;
        }
        this.selectedRsPropertyStrings = properties.get(String.valueOf(this.prefix) + TAG_RS_LIST_OPTIONS, this.selectedRsPropertyStrings);
        i = 0;
        while (i < this.selectedRsNames.length) {
            this.step = RecognitionStep.createRecognitionStep(this.selectedRsNames[i]);
            if (this.step != null) {
                this.step.readProperties(this.selectedRsPropertyStrings[i]);
                this.step.setHostName(this.hostName);
                this.step.setHostFrame(this.hostFrame);
                this.step.setBatchMode(this.batchMode);
                this.step.setConsoleMode(this.consoleMode);
                this.step.setStepMode(this.stepMode);
                this.step.setVerboseOption(this.verboseOption);
            }
            this.selectedRsObj[i] = this.step;
            ++i;
        }
    }

    @Override
    public StrictProperties writeAlgorithmParameters() {
        StrictProperties properties = new StrictProperties();
        properties.put(String.valueOf(this.prefix) + TAG_RS_LIST, this.selectedRsNames);
        properties.put(String.valueOf(this.prefix) + TAG_RS_LIST_OPTIONS, this.selectedRsPropertyStrings);
        return properties;
    }

    @Override
    public void tuneParametersManually() {
    }

    public StatusCode getCompletionStatus() {
        return this.completionStatus;
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public RecognitionStepList() {
        this.reset();
    }

    public RecognitionStepList(StepContent_Ix inputContent, StepContent_Ix outputContent) {
        this(inputContent, outputContent, null);
    }

    public RecognitionStepList(StepContent_Ix inputContent, StepContent_Ix outputContent, StepContent_Ix subPixelContent) {
        this.reset();
        this.initContent(inputContent, outputContent, subPixelContent);
    }

    public void initContent(StepContent_Ix inputContent, StepContent_Ix outputContent) {
        this.listInputContent = inputContent;
        this.listOutputContent = outputContent;
    }

    public void initContent(StepContent_Ix inputContent, StepContent_Ix outputContent, StepContent_Ix subPixelContent) {
        this.initContent(inputContent, outputContent);
        this.subPixelContent = subPixelContent;
    }

    public void initStepList() {
        this.selectedRsObj = new RecognitionStep[this.selectedRsNames.length];
    }

    public abstract void drawStep(StepContent_Ix var1);

    @Override
    public void run() {
        this.startOver();
        do {
            this.completionStatus = this.runNextRecognitionStep();
            if (this.step == null) continue;
            this.drawStep(this.step.outputContent);
        } while (this.completionStatus == StatusCode.CONTINUE);
    }

    public StatusCode runNextRecognitionStep() {
        StatusCode returnCode = StatusCode.CONTINUE;
        if (this.newStep) {
            if (this.selectedRsObj[this.stepNumber] == null) {
                this.step = RecognitionStepList.createRecognitionStep(this.selectedRsNames[this.stepNumber]);
                if (this.step == null) {
                    ++this.stepNumber;
                    return StatusCode.CONTINUE;
                }
                this.selectedRsObj[this.stepNumber] = this.step;
                this.step.readProperties(this.selectedRsPropertyStrings[this.stepNumber]);
            } else {
                this.step = this.selectedRsObj[this.stepNumber];
            }
            this.step.setInputContent(this.listInputContent);
            this.step.startOver();
            this.step.setHostName(this.getName());
            this.step.setHostFrame(this.hostFrame);
            this.step.setConsoleMode(this.consoleMode);
        }
        this.step.setBatchMode(this.batchMode);
        this.step.setSteppingMode(this.substepMode);
        this.step.setVerboseOption(this.verboseOption);
        if (this.substepMode) {
            returnCode = this.step.nextSubstep();
            if (returnCode != StatusCode.CONTINUE) {
                ++this.stepNumber;
                this.listInputContent = this.step.getOutputContent();
                this.newStep = true;
            } else {
                this.newStep = false;
            }
        } else {
            while ((returnCode = this.step.nextSubstep()) == StatusCode.CONTINUE) {
            }
            ++this.stepNumber;
            this.listInputContent = this.step.getOutputContent();
            this.newStep = true;
        }
        return returnCode;
    }

    public void reset() {
        this.listInputContent = null;
        this.listOutputContent = null;
        this.subPixelContent = null;
        this.startOver();
        if (this.hostName != null && this.hostName.length() > 0) {
            this.prefix = String.valueOf(this.hostName) + "_";
        }
    }

    @Override
    public void startOver() {
        this.stepNumber = 0;
        this.newStep = true;
    }

    public static RecognitionStep createRecognitionStep(String className) {
        RecognitionStep step = null;
        Class<?> tmpClass = null;
        try {
            tmpClass = Class.forName(className.trim());
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class '" + className + "' not found.");
            e.printStackTrace();
            return step;
        }
        try {
            step = (RecognitionStep)tmpClass.newInstance();
        }
        catch (IllegalAccessException e) {
            System.out.println("Access to class '" + className + "' denied.");
            e.printStackTrace();
            return step;
        }
        catch (InstantiationException e) {
            System.out.println("Cannot create instance of class '" + className + "'.");
            e.printStackTrace();
            return step;
        }
        return step;
    }
}

