/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.time;

import java.util.HashMap;
import java.util.Map;

public enum TimeMeasure {
    TM_MILLISECOND(1, 1000, "ms", "ms", "millisecond"),
    TM_SECOND(2, 60, "s", "sec", "second"),
    TM_MINUTE(3, 60, "m", "min", "minute"),
    TM_HOUR(4, 24, "h", "hr", "hour"),
    TM_DAY(5, 30, "day", "day", "day"),
    TM_MONTH(6, 12, "mo", "mon", "month"),
    TM_YEAR(7, 10, "y", "yr", "year"),
    TM_DECENNIUM(8, 10, "dec", "decen", "decennium"),
    TM_CENTENNIUM(9, 10, "cen", "centen", "centennium"),
    TM_MILLENNIUM(10, 0, "mil", "millen", "millennium");

    private static final Map<Integer, TimeMeasure> MAP_BY_ID;
    private static final Map<String, TimeMeasure> MAP_BY_SHORTNAME;
    private static final Map<String, TimeMeasure> MAP_BY_NAME;
    private static final Map<String, TimeMeasure> MAP_BY_FULLNAME;
    private static final String MSG_ERR_START = "Design error: ";
    private static final String MSG_ERR_END = ", is duplicated";
    private final int id;
    private final int qtyInNextUnits;
    private final String shortName;
    private final String name;
    private final String fullName;

    static {
        MAP_BY_ID = new HashMap<Integer, TimeMeasure>();
        MAP_BY_SHORTNAME = new HashMap<String, TimeMeasure>();
        MAP_BY_NAME = new HashMap<String, TimeMeasure>();
        MAP_BY_FULLNAME = new HashMap<String, TimeMeasure>();
        boolean first = true;
        int prevId = 0;
        TimeMeasure[] timeMeasureArray = TimeMeasure.values();
        int n = timeMeasureArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeMeasure timeMeasure = timeMeasureArray[n2];
            if (MAP_BY_ID.put(timeMeasure.getId(), timeMeasure) != null) {
                throw new RuntimeException("Design error: id, " + timeMeasure.getId() + MSG_ERR_END);
            }
            if (!first && timeMeasure.getId() < prevId) {
                throw new RuntimeException("Design error: id's are not in acsending order");
            }
            first = false;
            prevId = timeMeasure.getId();
            if (MAP_BY_SHORTNAME.put(timeMeasure.getShortName(), timeMeasure) != null) {
                throw new RuntimeException("Design error: short name, " + timeMeasure.getShortName() + MSG_ERR_END);
            }
            if (MAP_BY_NAME.put(timeMeasure.getName(), timeMeasure) != null) {
                throw new RuntimeException("Design error: name, " + timeMeasure.getName() + MSG_ERR_END);
            }
            if (MAP_BY_FULLNAME.put(timeMeasure.getFullName(), timeMeasure) != null) {
                throw new RuntimeException("Design error: full name, " + timeMeasure.getFullName() + MSG_ERR_END);
            }
            ++n2;
        }
    }

    private TimeMeasure(int id, int qtyInNextUnits, String shortName, String name, String fullName) {
        this.id = id;
        this.qtyInNextUnits = qtyInNextUnits;
        this.shortName = shortName;
        this.name = name;
        this.fullName = fullName;
    }

    public int getId() {
        return this.id;
    }

    public int getQtyInNextUnits() {
        return this.qtyInNextUnits;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isFirst() {
        return this.ordinal() == 0;
    }

    public boolean isLast() {
        return this.ordinal() == TimeMeasure.values().length - 1;
    }

    public TimeMeasure getPrev() {
        if (!this.isFirst()) {
            return TimeMeasure.values()[this.ordinal() - 1];
        }
        return null;
    }

    public TimeMeasure getNext() {
        if (!this.isLast()) {
            return TimeMeasure.values()[this.ordinal() + 1];
        }
        return null;
    }

    public boolean isLessThan(TimeMeasure timeMeasure) {
        return this.ordinal() < timeMeasure.ordinal();
    }

    public boolean isLessOrEqualThan(TimeMeasure timeMeasure) {
        return this.ordinal() <= timeMeasure.ordinal();
    }

    public static TimeMeasure get(int id) {
        return MAP_BY_ID.get(id);
    }

    public static TimeMeasure getByShortName(String shortName) {
        return MAP_BY_SHORTNAME.get(shortName);
    }

    public static TimeMeasure getByName(String name) {
        return MAP_BY_NAME.get(name);
    }

    public static TimeMeasure getByFullName(String fullName) {
        return MAP_BY_FULLNAME.get(fullName);
    }

    public static String[] getFullNames(TimeMeasure minMeasure, TimeMeasure maxMeasure) {
        String[] fullNames = new String[TimeMeasure.getQty(minMeasure, maxMeasure)];
        int index = 0;
        TimeMeasure[] timeMeasureArray = TimeMeasure.values();
        int n = timeMeasureArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeMeasure timeMeasure = timeMeasureArray[n2];
            if (minMeasure.isLessOrEqualThan(timeMeasure) && timeMeasure.isLessOrEqualThan(maxMeasure)) {
                fullNames[index++] = timeMeasure.getFullName();
            }
            ++n2;
        }
        return fullNames;
    }

    public static int getQty(TimeMeasure minMeasure, TimeMeasure maxMeasure) {
        if (minMeasure == null) {
            throw new IllegalArgumentException("minMeasure == null");
        }
        if (maxMeasure == null) {
            throw new IllegalArgumentException("maxMeasure == null");
        }
        if (maxMeasure.isLessThan(minMeasure)) {
            throw new IllegalArgumentException("maxMeasure < minMeasure");
        }
        int qty = 0;
        TimeMeasure[] timeMeasureArray = TimeMeasure.values();
        int n = timeMeasureArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeMeasure timeMeasure = timeMeasureArray[n2];
            if (minMeasure.isLessOrEqualThan(timeMeasure) && timeMeasure.isLessOrEqualThan(maxMeasure)) {
                ++qty;
            }
            ++n2;
        }
        return qty;
    }
}

