/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexDoubleFFT;
import jnt.FFT.ComplexDoubleFFT_Mixed;

public class ComplexDouble2DFFT {
    int nrows;
    int ncols;
    ComplexDoubleFFT rowFFT;
    ComplexDoubleFFT colFFT;

    public ComplexDouble2DFFT(int nrows, int ncols) {
        if (nrows <= 0 || ncols <= 0) {
            throw new IllegalArgumentException("The array dimensions >=0 : " + nrows + "," + ncols);
        }
        this.nrows = nrows;
        this.ncols = ncols;
        this.rowFFT = new ComplexDoubleFFT_Mixed(ncols);
        this.colFFT = nrows == ncols ? this.rowFFT : new ComplexDoubleFFT_Mixed(nrows);
    }

    protected void checkData(double[] data, int rowspan) {
        if (rowspan < 2 * this.ncols) {
            throw new IllegalArgumentException("The row span " + rowspan + "is shorter than the row length " + 2 * this.ncols);
        }
        if (this.nrows * rowspan > data.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.nrows + "x" + rowspan + " data.length=" + data.length);
        }
    }

    public void transform(double[] data) {
        this.transform(data, 2 * this.ncols);
    }

    public void transform(double[] data, int rowspan) {
        this.checkData(data, rowspan);
        int i = 0;
        while (i < this.nrows) {
            this.rowFFT.transform(data, i * rowspan, 2);
            ++i;
        }
        int j = 0;
        while (j < this.ncols) {
            this.colFFT.transform(data, 2 * j, rowspan);
            ++j;
        }
    }

    public double[] toWraparoundOrder(double[] data) {
        return data;
    }

    public double[] toWraparoundOrder(double[] data, int rowspan) {
        if (rowspan == 2 * this.ncols) {
            return data;
        }
        double[] newdata = new double[2 * this.nrows * this.ncols];
        int i = 0;
        while (i < this.nrows) {
            int j = 0;
            while (j < this.ncols) {
                newdata[i * 2 * this.ncols + 2 * j] = data[i * rowspan + 2 * j];
                newdata[i * 2 * this.ncols + 2 * j + 1] = data[i * rowspan + 2 * j + 1];
                ++j;
            }
            ++i;
        }
        return newdata;
    }

    public void backtransform(double[] data) {
        this.backtransform(data, 2 * this.ncols);
    }

    public void backtransform(double[] data, int rowspan) {
        this.checkData(data, rowspan);
        int j = 0;
        while (j < this.ncols) {
            this.colFFT.backtransform(data, 2 * j, rowspan);
            ++j;
        }
        int i = 0;
        while (i < this.nrows) {
            this.rowFFT.backtransform(data, i * rowspan, 2);
            ++i;
        }
    }

    public double normalization() {
        return 1.0 / ((double)this.nrows * (double)this.ncols);
    }

    public void inverse(double[] data) {
        this.inverse(data, 2 * this.ncols);
    }

    public void inverse(double[] data, int rowspan) {
        this.backtransform(data, rowspan);
        double norm = this.normalization();
        int i = 0;
        while (i < this.nrows) {
            int j = 0;
            while (j < this.ncols) {
                int n = i * rowspan + 2 * j;
                data[n] = data[n] * norm;
                int n2 = i * rowspan + 2 * j + 1;
                data[n2] = data[n2] * norm;
                ++j;
            }
            ++i;
        }
    }
}

