/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexDoubleFFT;
import jnt.FFT.Factorize;

public class ComplexDoubleFFT_Radix2
extends ComplexDoubleFFT {
    static final double PI = Math.PI;
    static final int FORWARD = -1;
    static final int BACKWARD = 1;
    static final int DECINTIME = 0;
    static final int DECINFREQ = 1;
    private int logn;
    private int decimate = 0;
    private double[] trigs;

    public ComplexDoubleFFT_Radix2(int n) {
        super(n);
        int log = Factorize.log2(n);
        if (log < 0) {
            throw new Error(String.valueOf(n) + " is not a power of 2");
        }
        this.logn = log;
        this.trigs = new double[this.logn + 1];
        double theta = Math.PI;
        int i = 0;
        while (i <= this.logn) {
            this.trigs[i] = Math.sin(theta);
            theta /= 2.0;
            ++i;
        }
    }

    public void setDecimateInTime() {
        this.decimate = 0;
    }

    public void setDecimateInFrequency() {
        this.decimate = 1;
    }

    @Override
    public void transform(double[] data, int i0, int stride) {
        this.checkData(data, i0, stride);
        this.transform_internal(data, i0, stride, -1);
    }

    @Override
    public void backtransform(double[] data, int i0, int stride) {
        this.checkData(data, i0, stride);
        this.transform_internal(data, i0, stride, 1);
    }

    void transform_internal(double[] data, int i0, int stride, int direction) {
        if (this.decimate == 1) {
            this.transform_DIF(data, i0, stride, direction);
        } else {
            this.transform_DIT(data, i0, stride, direction);
        }
    }

    void transform_DIT(double[] data, int i0, int stride, int direction) {
        if (this.n == 1) {
            return;
        }
        this.bitreverse(data, i0, stride);
        int bit = 0;
        int dual = 1;
        while (bit < this.logn) {
            double wd_imag;
            double wd_real;
            int j;
            int i;
            double w_real = 1.0;
            double w_imag = 0.0;
            int dual2 = dual << 1;
            double s = (double)direction * this.trigs[bit];
            double t = (double)direction * this.trigs[bit + 1];
            double s2 = 2.0 * t * t;
            int b = 0;
            while (b < this.n) {
                i = i0 + b * stride;
                j = i0 + (b + dual) * stride;
                wd_real = data[j];
                wd_imag = data[j + 1];
                data[j] = data[i] - wd_real;
                data[j + 1] = data[i + 1] - wd_imag;
                int n = i;
                data[n] = data[n] + wd_real;
                int n2 = i + 1;
                data[n2] = data[n2] + wd_imag;
                b += dual2;
            }
            int a = 1;
            while (a < dual) {
                double tmp_real = w_real - s * w_imag - s2 * w_real;
                double tmp_imag = w_imag + s * w_real - s2 * w_imag;
                w_real = tmp_real;
                w_imag = tmp_imag;
                int b2 = 0;
                while (b2 < this.n) {
                    i = i0 + (b2 + a) * stride;
                    j = i0 + (b2 + a + dual) * stride;
                    tmp_real = data[j];
                    tmp_imag = data[j + 1];
                    wd_real = w_real * tmp_real - w_imag * tmp_imag;
                    wd_imag = w_real * tmp_imag + w_imag * tmp_real;
                    data[j] = data[i] - wd_real;
                    data[j + 1] = data[i + 1] - wd_imag;
                    int n = i;
                    data[n] = data[n] + wd_real;
                    int n3 = i + 1;
                    data[n3] = data[n3] + wd_imag;
                    b2 += dual2;
                }
                ++a;
            }
            ++bit;
            dual <<= 1;
        }
    }

    void transform_DIF(double[] data, int i0, int stride, int direction) {
        if (this.n == 1) {
            return;
        }
        int bit = 0;
        int dual = this.n / 2;
        while (bit < this.logn) {
            double w_real = 1.0;
            double w_imag = 0.0;
            int dual2 = dual << 1;
            double s = (double)direction * this.trigs[this.logn - 1 - bit];
            double t = (double)direction * this.trigs[this.logn - bit];
            double s2 = 2.0 * t * t;
            int b = 0;
            while (b < dual) {
                int a = 0;
                while (a < this.n) {
                    int i = i0 + (b + a) * stride;
                    int j = i0 + (b + a + dual) * stride;
                    double t1_real = data[i] + data[j];
                    double t1_imag = data[i + 1] + data[j + 1];
                    double t2_real = data[i] - data[j];
                    double t2_imag = data[i + 1] - data[j + 1];
                    data[i] = t1_real;
                    data[i + 1] = t1_imag;
                    data[j] = w_real * t2_real - w_imag * t2_imag;
                    data[j + 1] = w_real * t2_imag + w_imag * t2_real;
                    a += dual2;
                }
                double tmp_real = w_real - s * w_imag - s2 * w_real;
                double tmp_imag = w_imag + s * w_real - s2 * w_imag;
                w_real = tmp_real;
                w_imag = tmp_imag;
                ++b;
            }
            ++bit;
            dual >>= 1;
        }
        this.bitreverse(data, i0, stride);
    }

    protected void bitreverse(double[] data, int i0, int stride) {
        int i = 0;
        int j = 0;
        while (i < this.n - 1) {
            if (i < j) {
                int ii = i0 + i * stride;
                int jj = i0 + j * stride;
                double tmp_real = data[ii];
                double tmp_imag = data[ii + 1];
                data[ii] = data[jj];
                data[ii + 1] = data[jj + 1];
                data[jj] = tmp_real;
                data[jj + 1] = tmp_imag;
            }
            int k = this.n / 2;
            while (k <= j) {
                j -= k;
                k /= 2;
            }
            j += k;
            ++i;
        }
    }
}

