/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.nc2;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.nc2.NC2Dataset;
import ncsa.hdf.object.nc2.NC2Datatype;
import ncsa.hdf.object.nc2.NC2Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NC2File
extends FileFormat {
    private static final long serialVersionUID = 6941235662108358451L;
    private int fid;
    private int flag;
    private MutableTreeNode rootNode;
    private NetcdfFile ncFile;
    private static boolean isFileOpen;

    public NC2File() {
        this("");
    }

    public NC2File(String pathname) {
        super(pathname);
        this.isReadOnly = true;
        isFileOpen = false;
        this.fid = -1;
        try {
            this.ncFile = new NetcdfFile(this.fullFileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isThisType(FileFormat fileformat) {
        return fileformat instanceof NC2File;
    }

    @Override
    public boolean isThisType(String filename) {
        boolean is_netcdf = false;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filename, "r");
        }
        catch (Exception ex) {
            raf = null;
        }
        if (raf == null) {
            try {
                raf.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            return false;
        }
        byte[] header = new byte[4];
        try {
            raf.read(header);
        }
        catch (Exception ex) {
            header = null;
        }
        if (header != null) {
            is_netcdf = header[0] == 67 && header[1] == 68 && header[2] == 70 && header[3] < 4;
        }
        try {
            raf.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return is_netcdf;
    }

    @Override
    public FileFormat createInstance(String filename, int access) throws Exception {
        return new NC2File(filename);
    }

    @Override
    public int open() throws Exception {
        if (!isFileOpen) {
            isFileOpen = true;
            this.rootNode = this.loadTree();
        }
        return 0;
    }

    private MutableTreeNode loadTree() {
        long[] oid = new long[]{0L};
        NC2Group rootGroup = new NC2Group(this, "/", null, null, oid);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootGroup){
            private static final long serialVersionUID = -9190644912409119072L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        if (this.ncFile == null) {
            return root;
        }
        Iterator it = this.ncFile.getVariables().iterator();
        Variable ncDataset = null;
        DefaultMutableTreeNode node = null;
        NC2Dataset d = null;
        while (it.hasNext()) {
            ncDataset = (Variable)it.next();
            oid[0] = ncDataset.hashCode();
            d = new NC2Dataset((FileFormat)this, ncDataset, oid);
            node = new DefaultMutableTreeNode(d);
            root.add(node);
            rootGroup.addToMemberList(d);
        }
        return root;
    }

    @Override
    public void close() throws IOException {
        if (this.ncFile != null) {
            this.ncFile.close();
        }
    }

    @Override
    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public NetcdfFile getNetcdfFile() {
        return this.ncFile;
    }

    @Override
    public Group createGroup(String name, Group pgroup) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Datatype createDatatype(int tclass, int tsize, int torder, int tsign) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Datatype createDatatype(int tclass, int tsize, int torder, int tsign, String name) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Dataset createScalarDS(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, Object fillValue, Object data) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Dataset createImage(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, int ncomp, int intelace, Object data) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void delete(HObject obj) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public TreeNode copy(HObject srcObj, Group dstGroup, String dstName) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    private TreeNode copyDataset(Dataset srcDataset, NC2Group pgroup) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    private TreeNode copyGroup(NC2Group srcGroup, NC2Group pgroup) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public void copyAttributes(HObject src, HObject dst) {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public void copyAttributes(int src_id, int dst_id) {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void writeAttribute(HObject obj, Attribute attr, boolean attrExisted) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public static Attribute convertAttribute(ucar.nc2.Attribute netcdfAttr) {
        Attribute ncsaAttr = null;
        if (netcdfAttr == null) {
            return null;
        }
        String attrName = netcdfAttr.getName();
        long[] attrDims = new long[]{netcdfAttr.getLength()};
        NC2Datatype attrType = new NC2Datatype(netcdfAttr.getDataType());
        ncsaAttr = new Attribute(attrName, attrType, attrDims);
        ncsaAttr.setValue(netcdfAttr.getValues());
        return ncsaAttr;
    }

    @Override
    public String getLibversion() {
        String ver = "NetCDF Java (version 2.4)";
        return ver;
    }

    @Override
    public HObject get(String path) throws Exception {
        throw new UnsupportedOperationException("get() is not supported");
    }
}

