/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.apps;

import edu.uml.giro.gambit.apps.GambitAppSettings;
import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.GambitCore;
import edu.uml.giro.gambit.core.LocalDataOneSiteAllTimes;
import edu.uml.lgdc.appuserdb.api.ApplicationPassport;
import edu.uml.lgdc.appuserdb.api.LgdcRegistry;
import edu.uml.lgdc.appuserdb.api.UserRole;
import edu.uml.lgdc.appuserdb.constants.Application;
import edu.uml.lgdc.database.DBConnect;
import edu.uml.lgdc.database.DatabaseContents;
import edu.uml.lgdc.database.DatabaseFarm;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.project.CommandLineParam;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.SharedResourcesDir;
import edu.uml.lgdc.time.TimeScale;

public class GambitReaderExample {
    public static final String INI_FILE_NAME = "GambitReader.ini";
    public static final String VERSION = "GAMBIT Database Reader Example v0.2";
    private static Application application = Application.get("GambitExplorer_UserApp");
    private static ApplicationPassport appPassport = null;
    private static GambitAppSettings settings = null;
    protected static GambitCore gambitCore;

    static {
        settings = new GambitAppSettings(INI_FILE_NAME);
        appPassport = new ApplicationPassport(application, UserRole.BROWSER, true, 0, null);
        DBConnect gambitDb = new DBConnect(settings.getDatabaseConnectionSettings().getConnectionRequisites("GAMBIT-DB"), DatabaseContents.IRTAM.getId(), 0);
        DatabaseFarm farm = new DatabaseFarm();
        farm.addConnect(gambitDb);
        farm.activateDefaultConnections();
        LgdcRegistry.addDatabaseFarm(appPassport, farm);
        gambitCore = new GambitCore(appPassport, GambitReaderExample.settings.gambitCoreSettings);
    }

    public GambitReaderExample() {
        System.out.println(VERSION);
        System.out.println("Online with Gambit Database at " + LgdcRegistry.lookupDatabaseFarm(application, DatabaseContents.IRTAM).getActiveDatabaseConnect(DatabaseContents.IRTAM).getRequisites().getURL());
        TimeScale tov = new TimeScale(2002, 4, 21, 21, 0, 0);
        System.out.println("Reading GAMBIT record for " + tov.toHumanUT() + "...");
        gambitCore.setTimeOfValidity(tov, 35, gambitCore.getGambitDatabaseReader().getBestAvailableVersions());
        System.out.println("done.");
        Geomap map1 = GambitReaderExample.gambitCore.getChar((CharChoice)CharChoice.FOF2).weatherMap;
        EarthGrid earthGrid = map1.getEarthGrid();
        double[][] mapValues = map1.getMap();
        LocalDataOneSiteAllTimes oneDayMHJ45_foF2 = gambitCore.getLocalData(CharChoice.FOF2).getSite("MHJ45");
        LocalDataOneSiteAllTimes oneDayMHJ45_hmF2 = gambitCore.getLocalData(CharChoice.HMF2).getSite("MHJ45");
        double[] observedValues_foF2 = oneDayMHJ45_foF2.getObservations();
        double[] climateValues_foF2 = oneDayMHJ45_foF2.getClimateValues();
        double[] observedValues_hmF2 = oneDayMHJ45_hmF2.getObservations();
        System.out.println("#-- Millstone Hill source data for TOV " + tov.toHumanUT() + ", starting at " + oneDayMHJ45_foF2.getFirstUT().toHumanUT());
        System.out.println("#-- Time ---------- foF2(obs) ---- foF2(climate) ---- hmF2(obs) ----");
        int i = 0;
        while (i < oneDayMHJ45_foF2.getDataLength()) {
            System.out.format("%s %6.3f %6.3f %6.1f\n", oneDayMHJ45_foF2.getTimeGrid().getUTs()[i], observedValues_foF2[i], climateValues_foF2[i], observedValues_hmF2[i]);
            ++i;
        }
        System.out.print("Stations contributed to IRTAM computation at " + tov.toHumanUT() + ": ");
        LocalDataOneSiteAllTimes[] sites = gambitCore.getLocalData(CharChoice.HMF2).getSites();
        int i2 = 0;
        LocalDataOneSiteAllTimes[] localDataOneSiteAllTimesArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            LocalDataOneSiteAllTimes site = localDataOneSiteAllTimesArray[n2];
            if (site != null && !site.isUnused()) {
                if (i2++ % 10 == 0) {
                    System.out.println();
                }
                StationLocation station = site.getLocation();
                System.out.print(String.valueOf(station.getUrsi()) + " ");
            }
            ++n2;
        }
        LgdcRegistry.releaseAllResources();
        System.out.println("\nFinished.");
    }

    public static void main(String[] args) {
        String result;
        CommandLineParam commandLineParam = new CommandLineParam(args);
        String errMsg = commandLineParam.checkParams(GambitConstants.KEYS, GambitConstants.KEY_TYPES, true);
        if (errMsg != null) {
            System.out.println(errMsg);
            System.exit(1);
        }
        if ((result = SharedResourcesDir.readAndSet(commandLineParam)) != null && result != SharedResourcesDir.NOT_SET) {
            Console.showError(result);
            System.exit(1);
        }
        GambitReaderExample grex = new GambitReaderExample();
    }
}

