/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.coefficients;

import edu.uml.giro.gambit.coefficients.Coefficients2D;
import edu.uml.giro.gambit.expansions.ExpansionBasis2D;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.MissingResourceException;

public class Coefficients_foF2
extends Coefficients2D {
    public static final String URSI_MODEL_PREF = "URSI";
    public static final String URSI_MODEL_EXT = "ASC";
    private int monthPrev = -1;
    private double rgPrev = -1.0;

    @Override
    public void loadFromClimateFile(int month, double sunspotNumber) {
        boolean LOW_R = false;
        boolean HIGH_R = true;
        if (this.basis == null) {
            throw new MissingResourceException("Call to read coefficients from climate file without basis", this.getClass().getName(), null);
        }
        ExpansionBasis2D basis2d = (ExpansionBasis2D)this.basis;
        if (this.coeffs == null || this.coeffs.length != basis2d.getCompactSpatialBasisLength() || this.coeffs[0].length != basis2d.getTemporalBasisLength()) {
            this.coeffs = new double[basis2d.getCompactSpatialBasisLength()][basis2d.getTemporalBasisLength()];
        }
        double[][][] foF2 = new double[2][basis2d.getCompactSpatialBasisLength()][basis2d.getTemporalBasisLength()];
        if (TimeScale.checkMonth(month)) {
            double rg = Math.min(150.0, sunspotNumber);
            if (month != this.monthPrev || rg != this.rgPrev) {
                int j;
                int i;
                block26: {
                    File file = new File(CommonConst.getShareResourcesDir(), URSI_MODEL_PREF + (10 + month) + "." + URSI_MODEL_EXT);
                    String fileURSI = file.getPath();
                    BufferedReader in = null;
                    i = 0;
                    j = 0;
                    int k = 0;
                    try {
                        try {
                            in = new BufferedReader(new FileReader(file));
                            while (in.ready()) {
                                String line = in.readLine();
                                if (line != null) {
                                    int m = 0;
                                    while (m < 4) {
                                        foF2[i][j][k] = FC.StringToDouble(line.substring(1 + m * 15, 1 + (m + 1) * 15));
                                        if (++k >= basis2d.getTemporalBasisLength()) {
                                            k = 0;
                                            if (++j >= basis2d.getCompactSpatialBasisLength()) {
                                                j = 0;
                                                ++i;
                                            }
                                        }
                                        ++m;
                                    }
                                    if (i != 2) {
                                        continue;
                                    }
                                }
                                break;
                            }
                        }
                        catch (IOException ex) {
                            System.err.println("ERROR-Coefficients_foF2: can't read file " + fileURSI);
                            System.err.println(ex.toString());
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException ex2) {
                                    ex2.printStackTrace();
                                }
                            }
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                double rr2 = rg / 100.0;
                double rr1 = 1.0 - rr2;
                i = 0;
                while (i < basis2d.getCompactSpatialBasisLength()) {
                    j = 0;
                    while (j < basis2d.getTemporalBasisLength()) {
                        this.coeffs[i][j] = foF2[0][i][j] * rr1 + foF2[1][i][j] * rr2;
                        ++j;
                    }
                    ++i;
                }
                this.monthPrev = month;
                this.rgPrev = rg;
            }
        }
    }
}

