/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

import edu.uml.giro.gambit.core.LocalData;
import edu.uml.giro.gambit.synthesizers.GeoSynthesizer;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.Geomap;
import java.util.Objects;

public class Characteristic {
    public final CharChoice cc;
    public final GeoSynthesizer climate;
    public final Geomap climateMap;
    public GeoSynthesizer weather;
    public Geomap weatherMap;
    public Geomap deviationMap;
    public final Geomap deviationMap_percent;
    public final LocalData localData;

    public Characteristic(CharChoice cc, Geomap climateMap, GeoSynthesizer climate, LocalData localData, Geomap weatherMap, GeoSynthesizer weather, Geomap deviationMap, Geomap deviationMap_percent) {
        this.cc = Objects.requireNonNull(cc);
        this.climateMap = Objects.requireNonNull(climateMap);
        this.climate = cc == CharChoice.VTEC || cc == CharChoice.TAU ? null : Objects.requireNonNull(climate);
        this.localData = cc == CharChoice.CUSTOM || cc == CharChoice.VTEC || cc == CharChoice.TAU ? null : Objects.requireNonNull(localData);
        this.weather = cc == CharChoice.CUSTOM || cc == CharChoice.VTEC || cc == CharChoice.TAU ? null : weather;
        this.weatherMap = cc == CharChoice.CUSTOM ? null : Objects.requireNonNull(weatherMap);
        this.deviationMap = cc == CharChoice.CUSTOM ? null : Objects.requireNonNull(deviationMap);
        this.deviationMap_percent = cc == CharChoice.CUSTOM ? null : Objects.requireNonNull(deviationMap_percent);
    }

    public void reset() {
        if (this.localData != null) {
            this.localData.reset();
        }
        if (this.weatherMap != null) {
            this.weatherMap.reset();
        }
        if (this.deviationMap != null) {
            this.deviationMap.reset();
        }
        if (this.deviationMap_percent != null) {
            this.deviationMap_percent.reset();
        }
    }

    public void setNewWeatherSynthesizer(GeoSynthesizer weather) {
        this.weather = Objects.requireNonNull(weather);
        weather.reset();
    }
}

