/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

import edu.uml.giro.gambit.coefficients.Coefficients;
import edu.uml.giro.gambit.coefficients.Coefficients_B0;
import edu.uml.giro.gambit.coefficients.Coefficients_B1;
import edu.uml.giro.gambit.coefficients.Coefficients_foF2;
import edu.uml.giro.gambit.coefficients.Coefficients_hmF2;
import edu.uml.giro.gambit.core.AlgorithmVersions;
import edu.uml.giro.gambit.core.Characteristic;
import edu.uml.giro.gambit.core.Core;
import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.GambitCoreSettings;
import edu.uml.giro.gambit.core.LocalData;
import edu.uml.giro.gambit.database.BlobContent;
import edu.uml.giro.gambit.database.GambitDatabaseReader;
import edu.uml.giro.gambit.expansions.ExpansionBasis_JonesGallet;
import edu.uml.giro.gambit.expansions.ExpansionBasis_JonesGalletWithTrend;
import edu.uml.giro.gambit.synthesizers.GeoSynthesizer;
import edu.uml.lgdc.appuserdb.api.ApplicationPassport;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.geospace.IGSRealTimeVTECGetter;
import edu.uml.lgdc.geospace.IRIModel;
import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.geospace.PlasmaMath;
import edu.uml.lgdc.geospace.UPCRapidVTECGetter;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.DebugParam;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Map;

public class GambitCore
extends Core {
    private GambitDatabaseReader gambitBase;
    private IGSRealTimeVTECGetter rttecGetter = new IGSRealTimeVTECGetter(GambitConstants.RTTEC_FOLDER);
    private UPCRapidVTECGetter uqrgtecGetter = new UPCRapidVTECGetter(GambitConstants.UQRGTEC_FOLDER);

    public GambitDatabaseReader getGambitBase() {
        return this.gambitBase;
    }

    public GambitCore(ApplicationPassport appPassport, GambitCoreSettings coreSettings, boolean localWeatherAvailable) {
        super(coreSettings);
        this.setGambitPassport(appPassport);
        this.gambitBase = new GambitDatabaseReader(appPassport, localWeatherAvailable);
    }

    public GambitCore(ApplicationPassport appPassport, GambitCoreSettings coreSettings) {
        super(coreSettings);
        this.setGambitPassport(appPassport);
        this.gambitBase = new GambitDatabaseReader(appPassport);
    }

    public static GambitCore getInstance(ApplicationPassport appPassport, GambitCoreSettings coreSettings) {
        return new GambitCore(appPassport, coreSettings);
    }

    @Override
    public void reconstruct(AlgorithmVersions selectedVersions) {
        AlgorithmVersions versions = selectedVersions;
        if (selectedVersions.versionID == 0) {
            int latestVersionId = this.gambitBase.getLatestVersionId(this.timeOfValidity);
            versions = GambitDatabaseReader.GAMBIT_DB_VERSIONS.get(latestVersionId);
        }
        if (this.VERSIONS != null && versions.versionID == this.VERSIONS.versionID) {
            return;
        }
        this.VERSIONS = versions;
        CharChoice[] charChoiceArray = CharChoice.values();
        int n = charChoiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            CharChoice cc = charChoiceArray[n2];
            switch (cc) {
                case FOF2: {
                    Coefficients_foF2 coeffs_foF2w = new Coefficients_foF2();
                    ExpansionBasis_JonesGallet basis_foF2 = null;
                    if (versions.expansionBasisName.equals("JonesGallet")) {
                        basis_foF2 = new ExpansionBasis_JonesGallet();
                    }
                    if (versions.expansionBasisName.equals("JonesGallet_LinTrend")) {
                        basis_foF2 = new ExpansionBasis_JonesGalletWithTrend();
                    }
                    basis_foF2.setup(6, 8, 11);
                    basis_foF2.setExpansionBasisName(versions.expansionBasisName);
                    coeffs_foF2w.setExpansionBasis(basis_foF2);
                    this.weather_foF2 = new GeoSynthesizer(CharChoice.FOF2, basis_foF2, coeffs_foF2w, null);
                    this.weather_foF2.setTimeGrid(this.defaultTimeGrid);
                    this.weather_foF2.setEarthGrid(this.defaultEarthGrid);
                    this.weather_foF2.setAssimilationMethodName(versions.assimilationName);
                    this.weather_foF2.setIrtamVersionIdent(versions.versionID);
                    this.chars[CharChoice.FOF2.getIndex()].setNewWeatherSynthesizer(this.weather_foF2);
                    break;
                }
                case NMF2: {
                    GeoSynthesizer weather_NmF2 = new GeoSynthesizer(CharChoice.NMF2, this.weather_foF2.getExpansionBasis(), null, new GeoSynthesizer[]{this.weather_foF2});
                    this.chars[CharChoice.NMF2.getIndex()].setNewWeatherSynthesizer(weather_NmF2);
                    break;
                }
                case HMF2: {
                    Coefficients_hmF2 coeffs_hmF2w = new Coefficients_hmF2();
                    ExpansionBasis_JonesGallet basis_hmF2 = null;
                    if (versions.expansionBasisName.equals("JonesGallet")) {
                        basis_hmF2 = new ExpansionBasis_JonesGallet();
                    }
                    if (versions.expansionBasisName.equals("JonesGallet_LinTrend")) {
                        basis_hmF2 = new ExpansionBasis_JonesGalletWithTrend();
                    }
                    basis_hmF2.setup(6, 8, 11);
                    basis_hmF2.setExpansionBasisName(versions.expansionBasisName);
                    coeffs_hmF2w.setExpansionBasis(basis_hmF2);
                    this.weather_hmF2 = new GeoSynthesizer(CharChoice.HMF2, basis_hmF2, coeffs_hmF2w, null);
                    this.weather_hmF2.setTimeGrid(this.defaultTimeGrid);
                    this.weather_hmF2.setEarthGrid(this.defaultEarthGrid);
                    this.weather_hmF2.setAssimilationMethodName(versions.assimilationName);
                    this.weather_hmF2.setIrtamVersionIdent(versions.versionID);
                    this.chars[CharChoice.HMF2.getIndex()].setNewWeatherSynthesizer(this.weather_hmF2);
                    break;
                }
                case MUF3000: {
                    GeoSynthesizer weather_MUF3000 = new GeoSynthesizer(CharChoice.MUF3000, this.weather_foF2.getExpansionBasis(), null, new GeoSynthesizer[]{this.weather_foF2, this.weather_hmF2});
                    weather_MUF3000.setIRI(new IRIModel());
                    this.chars[CharChoice.MUF3000.getIndex()].setNewWeatherSynthesizer(weather_MUF3000);
                    break;
                }
                case B0: {
                    Coefficients_B0 coeffs_B0w = new Coefficients_B0();
                    ExpansionBasis_JonesGallet basis_B0 = null;
                    if (versions.expansionBasisName.equals("JonesGallet")) {
                        basis_B0 = new ExpansionBasis_JonesGallet();
                    }
                    if (versions.expansionBasisName.equals("JonesGallet_LinTrend")) {
                        basis_B0 = new ExpansionBasis_JonesGalletWithTrend();
                    }
                    basis_B0.setup(6, 8, 11);
                    basis_B0.setExpansionBasisName(versions.expansionBasisName);
                    coeffs_B0w.setExpansionBasis(basis_B0);
                    GeoSynthesizer weather_B0 = new GeoSynthesizer(CharChoice.B0, basis_B0, coeffs_B0w, null);
                    weather_B0.setTimeGrid(this.defaultTimeGrid);
                    weather_B0.setEarthGrid(this.defaultEarthGrid);
                    weather_B0.setAssimilationMethodName(versions.assimilationName);
                    weather_B0.setIrtamVersionIdent(versions.versionID);
                    this.chars[CharChoice.B0.getIndex()].setNewWeatherSynthesizer(weather_B0);
                    break;
                }
                case B1: {
                    Coefficients_B1 coeffs_B1w = new Coefficients_B1();
                    ExpansionBasis_JonesGallet basis_B1 = null;
                    if (versions.expansionBasisName.equals("JonesGallet")) {
                        basis_B1 = new ExpansionBasis_JonesGallet();
                    }
                    if (versions.expansionBasisName.equals("JonesGallet_LinTrend")) {
                        basis_B1 = new ExpansionBasis_JonesGalletWithTrend();
                    }
                    basis_B1.setup(6, 8, 11);
                    basis_B1.setExpansionBasisName(versions.expansionBasisName);
                    coeffs_B1w.setExpansionBasis(basis_B1);
                    GeoSynthesizer weather_B1 = new GeoSynthesizer(CharChoice.B1, basis_B1, coeffs_B1w, null);
                    weather_B1.setTimeGrid(this.defaultTimeGrid);
                    weather_B1.setEarthGrid(this.defaultEarthGrid);
                    weather_B1.setAssimilationMethodName(versions.assimilationName);
                    weather_B1.setIrtamVersionIdent(versions.versionID);
                    this.chars[CharChoice.B1.getIndex()].setNewWeatherSynthesizer(weather_B1);
                    break;
                }
                case VTEC: 
                case TAU: 
                case CUSTOM: {
                    break;
                }
                default: {
                    throw new RuntimeException("design error: overlooked characteristic, " + cc.getName());
                }
            }
            this.chars[cc.getIndex()].reset();
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rebuildOneChar_ObservationsAndWeather(Characteristic c, int databaseMode) {
        CharChoice cc = c.cc;
        if (cc == CharChoice.VTEC) {
            if ((databaseMode & 0x10) == 0) {
                if (!DebugParam.debug && DebugParam.verboseLevel < 4) return;
                Console.showMsg("Download of real-time VTEC map is bypassed");
                return;
            }
            if (this.uqrgtecGetter.downloadRapidTEC(this.timeOfValidity) == null) return;
            this.uqrgtecGetter.fillGambitMap(c.weatherMap, this.timeOfValidity);
            return;
        }
        if (cc == CharChoice.TAU) {
            if ((databaseMode & 0x10) == 0) {
                return;
            }
            Geomap wNmF2 = this.chars[CharChoice.NMF2.getIndex()].weatherMap;
            Geomap wTEC = this.chars[CharChoice.VTEC.getIndex()].weatherMap;
            double[] mapNmF2 = wNmF2.getMap_1D();
            double[] mapRTTEC = wTEC.getMap_1D();
            double[] mapTau = new double[mapNmF2.length];
            int i = 0;
            while (i < mapTau.length) {
                if (mapRTTEC[i] != wTEC.getNoValue() && mapNmF2[i] != wNmF2.getNoValue() && mapRTTEC[i] > this.coreSettings.getMinimumTecForTau() && mapNmF2[i] > this.coreSettings.getMinimumNmF2ForTau()) {
                    mapTau[i] = PlasmaMath.slabThickness_km(mapRTTEC[i], mapNmF2[i]);
                    if (mapTau[i] > this.coreSettings.getMaximumTau()) {
                        mapTau[i] = c.weatherMap.getNoValue();
                    }
                } else {
                    mapTau[i] = c.weatherMap.getNoValue();
                }
                ++i;
            }
            c.weatherMap.setMapValues(mapTau, this.timeOfValidity);
            return;
        }
        LocalData localData = c.localData;
        localData.getTimeGrid().setUTs(this.timeOfValidity);
        if (cc.isDerived()) {
            if ((databaseMode & 2) != 0) {
                if (cc == CharChoice.NMF2) {
                    localData.deriveFrom(new LocalData[]{this.chars[CharChoice.FOF2.getIndex()].localData});
                }
                if (cc == CharChoice.MUF3000) {
                    localData.deriveFrom(new LocalData[]{this.chars[CharChoice.FOF2.getIndex()].localData, this.chars[CharChoice.HMF2.getIndex()].localData});
                }
                if (DebugParam.debug || DebugParam.verboseLevel >= 4) {
                    Console.showMsg("GAMBIT Core: " + cc.getName() + " observations derived from " + this.chars[cc.getDerivedFrom()].cc.getName());
                }
                localData.deriveClimateValues(c.climate);
                int i = 0;
                while (i < localData.totalLocations) {
                    localData.sites[i].calculateO2Cdifferences();
                    ++i;
                }
            }
            if ((databaseMode & 1) == 0) return;
            int iTime = this.chars[cc.getDerivedFrom()].weather.getTimeGrid().getNumDiurnalSteps() - 1;
            c.weatherMap.setMapValues(c.weather.synthesizeValueMap(iTime), this.timeOfValidity);
            int i = 0;
            while (i < localData.totalLocations) {
                localData.sites[i].deriveGlobalWeatherValues(c.weather);
                localData.sites[i].calculateO2GWdifferences();
                ++i;
            }
            return;
        } else {
            Coefficients<?> coeffs = c.weather.getCoefficients();
            try {
                BlobContent blob = this.gambitBase.download(c.weather, localData, this.timeOfValidity, databaseMode);
                InputStream is = null;
                if ((databaseMode & 2) != 0) {
                    is = blob.getObservationStream(cc);
                    if (is != null) {
                        is.mark(is.available());
                        localData.loadFromInputStream(this.timeOfValidity, is, GambitDatabaseReader.GAMBIT_STATIONS, this.VERSIONS);
                        localData.fillClimateValues(c.climate);
                        localData.processRawData(this.timeOfValidity);
                        is.reset();
                        if (DebugParam.debug || DebugParam.verboseLevel >= 3) {
                            Console.showMsg("GAMBIT Core: " + cc.getName() + " observations downloaded");
                        }
                    } else {
                        System.err.println("GambitCore-ERROR: no observations found... database stream is empty");
                    }
                }
                if ((databaseMode & 1) != 0) {
                    is = blob.getGlobalWeatherStream(cc);
                    if (is != null) {
                        is.mark(is.available());
                        coeffs.loadFromInputStream(is);
                        is.reset();
                        if (DebugParam.debug || DebugParam.verboseLevel >= 3) {
                            Console.showMsg("GAMBIT Core: " + cc.getName() + " coefficients downloaded");
                        }
                        c.weather.getExpansionBasis().computeTimeDependentConstants(this.timeOfValidity);
                        int iTime = c.weather.getTimeGrid().findClosestTimeStep(this.timeOfValidity);
                        c.weatherMap.setMapValues(c.weather.synthesizeValueMap(iTime), this.timeOfValidity);
                        int i = 0;
                        while (i < localData.totalLocations) {
                            localData.sites[i].fillGlobalWeatherValues(c.weather);
                            localData.sites[i].calculateO2GWdifferences();
                            ++i;
                        }
                    } else {
                        System.err.println("GambitCore-ERROR: no weather coefficients found... database stream is empty");
                    }
                }
                if ((databaseMode & 0x20) == 0) return;
                Map<String, double[]> localWeatherCoeffs = blob.getLocalWeather(cc);
                int count = localData.loadLocalWeatherCoeffs(localWeatherCoeffs);
                if (count == 0) {
                    System.err.println("GambitCore-ERROR: no local weather coefficients found in database for " + cc.getName() + " at " + this.timeOfValidity.toHumanUT());
                    return;
                }
                if (DebugParam.debug || DebugParam.verboseLevel >= 3) {
                    Console.showMsg("GAMBIT Core: " + cc.getName() + " local weather coefficients downloaded");
                }
                c.weather.getExpansionBasis().computeTimeDependentConstants(this.timeOfValidity);
                localData.fillLocalWeatherValues(c.weather);
                return;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public GambitDatabaseReader getGambitDatabaseReader() {
        return this.gambitBase;
    }

    public ApplicationPassport getGambitPassport() {
        return this.appPassport;
    }

    public void setGambitPassport(ApplicationPassport appPassport) {
        this.appPassport = appPassport;
    }

    @Override
    public GambitCoreSettings getGambitCoreSettings() {
        return this.coreSettings;
    }

    public void transformOneMap(Geomap map, int option) {
    }

    public void transformAllMaps(int option) {
        Characteristic[] characteristicArray = this.chars;
        int n = this.chars.length;
        int n2 = 0;
        while (n2 < n) {
            Characteristic c = characteristicArray[n2];
            this.transformMap(c.climateMap, option);
            this.transformMap(c.weatherMap, option);
            this.transformMap(c.deviationMap, option);
            this.transformMap(c.deviationMap_percent, option);
            ++n2;
        }
    }

    public void transformMap(Geomap map, int option) {
        if (map == null) {
            return;
        }
        ExpansionBasis_JonesGallet basis = (ExpansionBasis_JonesGallet)this.chars[0].climate.getExpansionBasis();
        double[] buffer = new double[basis.getEarthGrid().getNumLatitudeNodes()];
        int numLats = basis.getEarthGrid().getNumLatitudeNodes();
        int iLon = 0;
        int[] newLatIndices = new int[numLats];
        if (option == 1 && !map.isDemagnetized()) {
            iLon = 0;
            while (iLon < basis.getEarthGrid().getNumLongitudeNodes()) {
                int iLat = 0;
                while (iLat < numLats) {
                    double modip = basis.getModip(iLat, iLon);
                    newLatIndices[iLat] = (int)((modip + 1.5707963267948966) * (double)(numLats - 1) / Math.PI);
                    ++iLat;
                }
                this.moveDemagValues(map, iLon, newLatIndices, buffer);
                ++iLon;
            }
            Geomap.compute1Dfrom2D(map.getMap_1D(), map.getMap());
            map.setDemagnetized(true);
        }
        if (option == 2 && map.isDemagnetized()) {
            MapChoice mapChoice = map.getMapChoice();
            CharChoice cc = mapChoice.getCC();
            Characteristic c = this.getChar(cc);
            this.rebuildOneChar(c, 1);
        }
    }

    private void moveDemagValues(Geomap map, int iLon, int[] newLatIndices, double[] buffer) {
        if (map == null) {
            return;
        }
        int iLat = 0;
        while (iLat < buffer.length) {
            buffer[iLat] = map.getNoValue();
            ++iLat;
        }
        boolean emptyMap = true;
        iLat = 0;
        while (iLat < buffer.length) {
            if (newLatIndices[iLat] >= 0 && newLatIndices[iLat] < buffer.length) {
                double value;
                buffer[newLatIndices[iLat]] = value = map.getMap()[iLat][iLon];
                if (value != map.getNoValue()) {
                    emptyMap = false;
                }
            }
            ++iLat;
        }
        if (emptyMap) {
            return;
        }
        int iNext = 0;
        iLat = 0;
        while (iLat < buffer.length) {
            if (buffer[iLat] == map.getNoValue() && iLat > 0) {
                iNext = iLat + 1;
                while (iNext < buffer.length && buffer[iNext] == map.getNoValue()) {
                    ++iNext;
                }
                double slope = (buffer[iNext] - buffer[iLat - 1]) / (double)(iNext - iLat + 1);
                int i = iLat;
                while (i < iNext) {
                    buffer[i] = buffer[iLat - 1] + slope * (double)(i - iLat + 1);
                    ++i;
                }
            }
            ++iLat;
        }
        iLat = 0;
        while (iLat < buffer.length) {
            map.getMap()[iLat][iLon] = buffer[iLat];
            map.getMap_1D()[iLon * buffer.length + iLat] = buffer[iLat];
            ++iLat;
        }
    }
}

