/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

import edu.uml.lgdc.geospace.PlasmaMath;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.settings.AppSettings;
import edu.uml.lgdc.project.settings.ContentType;
import edu.uml.lgdc.project.settings.OptionDesc;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.SectionDescriptor;
import java.util.HashMap;
import java.util.Map;

public class GambitCoreSettings
extends SectionDescriptor<GambitCoreSettings>
implements Cloneable {
    public static final String SECTION_NAME = "GAMBIT Explorer Core";
    public static final String OPTION_DAY_BOUNDARY_FIX = "DayBoundaryFix";
    public static final String OPTION_NUM_BUFFERED_DAYS = "NumBufferedDays";
    public static final String OPTION_FORECAST_PERIOD_MIN = "ForecastPeriod_min";
    public static final String OPTION_DOWNLOAD_OBSERVATIONS = "DownloadObservations";
    public static final String OPTION_DOWNLOAD_GLOBAL_COEFS = "DownloadGlobalWeather";
    public static final String OPTION_DOWNLOAD_LOCAL_COEFS = "DownloadLocalWeather";
    public static final String OPTION_RERUN_ASSIMILATION = "RerunAssimilation";
    public static final String OPTION_SUBMIT_ASSIMILATION = "SubmitAssimilation";
    public static final String OPTION_MIN_TEC_FOR_TAU = "MinimumTecForTau";
    public static final String OPTION_MIN_NMF2_FOR_TAU = "MinimumNmF2ForTau";
    public static final String OPTION_MAX_TAU = "MaximumTau";
    private boolean windowBoundaryFixEnabled;
    private int numBufferedDays;
    private long forecastPeriod_min;
    private boolean downloadObservations;
    private boolean downloadGlobalWeather;
    private boolean downloadLocalWeather;
    private boolean rerunAssimilation;
    private boolean submitAssimilation;
    private double minimumTecForTau;
    private double minimumNmF2ForTau;
    private double maximumTau;
    private final Map<String, OptionDesc> descriptor = new HashMap<String, OptionDesc>(32);

    public GambitCoreSettings() {
        this.setDefaults();
        this.fillDescriptor();
    }

    @Override
    public Map<String, OptionDesc> getOptionsDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getName() {
        return SECTION_NAME;
    }

    @Override
    public GambitCoreSettings getThis() {
        return this;
    }

    protected void setDefaults() {
        this.windowBoundaryFixEnabled = false;
        this.numBufferedDays = 0;
        this.forecastPeriod_min = 0L;
        this.downloadObservations = true;
        this.downloadGlobalWeather = true;
        this.downloadLocalWeather = true;
        this.rerunAssimilation = false;
        this.submitAssimilation = false;
        this.minimumTecForTau = 8.0;
        this.minimumNmF2ForTau = PlasmaMath.freq2density(2.0);
        this.maximumTau = 1000.0;
    }

    @Override
    protected void fillDescriptor() {
        this.descriptor.put(OPTION_DAY_BOUNDARY_FIX, new OptionDesc((Object)this.windowBoundaryFixEnabled, ContentType.CORE));
        this.descriptor.put(OPTION_NUM_BUFFERED_DAYS, new OptionDesc((Object)this.numBufferedDays, ContentType.MISC));
        this.descriptor.put(OPTION_FORECAST_PERIOD_MIN, new OptionDesc((Object)this.forecastPeriod_min, ContentType.MISC));
        this.descriptor.put(OPTION_DOWNLOAD_OBSERVATIONS, new OptionDesc((Object)this.downloadObservations, ContentType.MISC));
        this.descriptor.put(OPTION_DOWNLOAD_GLOBAL_COEFS, new OptionDesc((Object)this.downloadGlobalWeather, ContentType.MISC));
        this.descriptor.put(OPTION_DOWNLOAD_LOCAL_COEFS, new OptionDesc((Object)this.downloadLocalWeather, ContentType.MISC));
        this.descriptor.put(OPTION_RERUN_ASSIMILATION, new OptionDesc((Object)this.rerunAssimilation, ContentType.MISC));
        this.descriptor.put(OPTION_SUBMIT_ASSIMILATION, new OptionDesc((Object)this.submitAssimilation, ContentType.MISC));
        this.descriptor.put(OPTION_MIN_TEC_FOR_TAU, new OptionDesc((Object)this.minimumTecForTau, ContentType.MISC));
        this.descriptor.put(OPTION_MIN_NMF2_FOR_TAU, new OptionDesc((Object)this.minimumNmF2ForTau, ContentType.MISC));
        this.descriptor.put(OPTION_MAX_TAU, new OptionDesc((Object)this.maximumTau, ContentType.MISC));
    }

    @Override
    public void getFrom(OptionsIO optionsIO) {
        try {
            this.windowBoundaryFixEnabled = AppSettings.getBoolean(optionsIO, SECTION_NAME, OPTION_DAY_BOUNDARY_FIX, this.windowBoundaryFixEnabled);
            this.numBufferedDays = Integer.parseInt(optionsIO.get(SECTION_NAME, OPTION_NUM_BUFFERED_DAYS));
            this.forecastPeriod_min = Integer.parseInt(optionsIO.get(SECTION_NAME, OPTION_FORECAST_PERIOD_MIN));
            this.downloadObservations = AppSettings.getBoolean(optionsIO, SECTION_NAME, OPTION_DOWNLOAD_OBSERVATIONS, this.downloadObservations);
            this.downloadGlobalWeather = AppSettings.getBoolean(optionsIO, SECTION_NAME, OPTION_DOWNLOAD_GLOBAL_COEFS, this.downloadGlobalWeather);
            this.downloadLocalWeather = AppSettings.getBoolean(optionsIO, SECTION_NAME, OPTION_DOWNLOAD_LOCAL_COEFS, this.downloadLocalWeather);
            this.rerunAssimilation = AppSettings.getBoolean(optionsIO, SECTION_NAME, OPTION_RERUN_ASSIMILATION, this.rerunAssimilation);
            this.submitAssimilation = AppSettings.getBoolean(optionsIO, SECTION_NAME, OPTION_SUBMIT_ASSIMILATION, this.submitAssimilation);
            this.minimumTecForTau = Double.parseDouble(optionsIO.get(SECTION_NAME, OPTION_MIN_TEC_FOR_TAU));
            this.minimumNmF2ForTau = Double.parseDouble(optionsIO.get(SECTION_NAME, OPTION_MIN_NMF2_FOR_TAU));
            this.maximumTau = Double.parseDouble(optionsIO.get(SECTION_NAME, OPTION_MAX_TAU));
        }
        catch (IllegalArgumentException e) {
            Console.showError(e.getMessage());
        }
    }

    @Override
    public void putTo(OptionsIO optionsIO) {
        optionsIO.put(SECTION_NAME, OPTION_DAY_BOUNDARY_FIX, String.valueOf(this.windowBoundaryFixEnabled));
        optionsIO.put(SECTION_NAME, OPTION_NUM_BUFFERED_DAYS, String.valueOf(this.numBufferedDays));
        optionsIO.put(SECTION_NAME, OPTION_FORECAST_PERIOD_MIN, String.valueOf(this.forecastPeriod_min));
        optionsIO.put(SECTION_NAME, OPTION_DOWNLOAD_OBSERVATIONS, String.valueOf(this.downloadObservations));
        optionsIO.put(SECTION_NAME, OPTION_DOWNLOAD_GLOBAL_COEFS, String.valueOf(this.downloadGlobalWeather));
        optionsIO.put(SECTION_NAME, OPTION_DOWNLOAD_LOCAL_COEFS, String.valueOf(this.downloadLocalWeather));
        optionsIO.put(SECTION_NAME, OPTION_RERUN_ASSIMILATION, String.valueOf(this.rerunAssimilation));
        optionsIO.put(SECTION_NAME, OPTION_SUBMIT_ASSIMILATION, String.valueOf(this.submitAssimilation));
        optionsIO.put(SECTION_NAME, OPTION_MIN_TEC_FOR_TAU, String.valueOf(this.minimumTecForTau));
        optionsIO.put(SECTION_NAME, OPTION_MIN_NMF2_FOR_TAU, String.valueOf(this.minimumNmF2ForTau));
        optionsIO.put(SECTION_NAME, OPTION_MAX_TAU, String.valueOf(this.maximumTau));
    }

    public boolean isDayBoundaryFixEnabled() {
        return this.windowBoundaryFixEnabled;
    }

    public boolean isWindowBoundaryMitigationEnabled() {
        return this.windowBoundaryFixEnabled;
    }

    public int getNumBufferedDays() {
        return this.numBufferedDays;
    }

    public long getForecastPeriod_min() {
        return this.forecastPeriod_min;
    }

    public boolean isDownloadObservations() {
        return this.downloadObservations;
    }

    public void setDownloadObservations(boolean b) {
        this.downloadObservations = b;
    }

    public boolean isDownloadGlobalWeather() {
        return this.downloadGlobalWeather;
    }

    public void setDownloadGlobalWeather(boolean b) {
        this.downloadGlobalWeather = b;
    }

    public boolean isDownloadLocalWeather() {
        return this.downloadLocalWeather;
    }

    public void setDownloadLocalWeather(boolean b) {
        this.downloadLocalWeather = b;
    }

    public boolean isRerunAssimilation() {
        return this.rerunAssimilation;
    }

    public void setRerunAssimilation(boolean b) {
        this.rerunAssimilation = b;
    }

    public boolean isSubmitAssimilation() {
        return this.submitAssimilation;
    }

    public void setSubmitAssimilation(boolean b) {
        this.submitAssimilation = b;
    }

    public double getMinimumTecForTau() {
        return this.minimumTecForTau;
    }

    public void setMinimumTecForTau(double minimumTecForTau) {
        this.minimumTecForTau = minimumTecForTau;
    }

    public double getMinimumNmF2ForTau() {
        return this.minimumNmF2ForTau;
    }

    public void setMinimumNmF2ForTau(double minimumNmF2ForTau) {
        this.minimumNmF2ForTau = minimumNmF2ForTau;
    }

    public double getMaximumTau() {
        return this.maximumTau;
    }

    public void setMaximumTau(double maximumTau) {
        this.maximumTau = maximumTau;
    }

    public void setForecastPeriod(long minutes) {
        this.forecastPeriod_min = minutes;
    }
}

