/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

public class IonogramScaling {
    public static final int FORECAST_CONFIDENCE_SCORE = 31;
    public static final int POOR_CONFIDENCE_SCORE = 41;
    public static final int UNKNOWN_CONFIDENCE_SCORE = 51;
    public static final int GOOD_CONFIDENCE_SCORE = 80;
    public static final int MANUAL_CONFIDENCE_SCORE = 999;
    public static final int NOT_APPLICABLE_CONFIDENCE_SCORE = -1;
    public static final int ACCEPTED_ASIS = 1;
    public static final int INTERPOLATED_MISSING = 2;
    public static final int INTERPOLATED_POOR_QUALITY = 4;
    public static final int INTERPOLATED = 6;
    public static final int DAY_BOUNDARY = 8;
    public static final int FORECAST = 16;
    public static final int TIMEGRID_MISMATCH_THRESHOLD = 33;

    public static boolean isMissing(double rawObservation) {
        return rawObservation == 9999.0 || rawObservation == 0.0;
    }

    public static boolean isPoorQuality(int confidenceScore) {
        return confidenceScore < 41;
    }

    public static boolean isHighQuality(int confidenceScore) {
        return confidenceScore > 80;
    }

    public static boolean isManual(int confidenceScore) {
        return confidenceScore == 999;
    }

    public static boolean isUnknownQuality(int confidenceScore) {
        return confidenceScore == 51;
    }

    public static boolean isTooFar(int timeGridMismatchPercent) {
        return timeGridMismatchPercent > 33;
    }

    public static boolean isAcceptedAsIs(int gambitFlag) {
        return (gambitFlag & 1) > 0;
    }

    public static boolean isDayBoundary(int gambitFlag) {
        return (gambitFlag & 8) > 0;
    }

    public static boolean isFilledGap(int gambitFlag) {
        return (gambitFlag & 2) > 0;
    }

    public static boolean isReplaced(int gambitFlag) {
        return (gambitFlag & 4) > 0;
    }

    public static boolean isForecast(int gambitFlag) {
        return (gambitFlag & 0x10) > 0;
    }
}

