/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

import edu.uml.giro.gambit.core.LocalData;
import edu.uml.giro.gambit.core.LocalDataElements;
import edu.uml.giro.gambit.core.SitesChoice;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.math.SimpleMetrics;
import edu.uml.lgdc.time.TimeScale;
import java.util.ArrayList;
import java.util.HashMap;

public class LocalDataAllSitesOneTime {
    public HashMap<StationLocation, LocalDataElements> data = new HashMap();
    private SimpleMetrics metrics = new SimpleMetrics();
    private TimeScale time;

    public LocalDataAllSitesOneTime(LocalData input, TimeScale targetTime) {
        if (!targetTime.equals(this.time)) {
            this.data.clear();
            int iSite = 0;
            while (iSite < input.totalLocations) {
                LocalDataElements site;
                if (!input.sites[iSite].isUnused() && !(site = input.sites[iSite].getDataCell(targetTime)).isEmpty()) {
                    this.data.put(input.sites[iSite].getLocation(), site);
                }
                ++iSite;
            }
        }
    }

    public SimpleMetrics getMetrics(SitesChoice sitesChoice, boolean percent) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (LocalDataElements site : this.data.values()) {
            double value = this.getValue(site, sitesChoice, percent);
            if (value == 9999.0) continue;
            values.add(value);
        }
        if (values.size() == 0) {
            this.metrics.clear();
        } else {
            double[] array = new double[values.size()];
            int i = 0;
            while (i < values.size()) {
                array[i] = (Double)values.get(i);
                ++i;
            }
            this.metrics.compute(array, values.size(), 9999.0);
        }
        return this.metrics;
    }

    public HashMap<StationLocation, LocalDataElements> getData() {
        return this.data;
    }

    public double getValue(LocalDataElements site, SitesChoice sc, boolean percent) {
        double value;
        if (sc.isObservations()) {
            value = site.getObservation();
        } else if (sc.isVersusEmpiricalModel()) {
            value = percent ? site.getO2C_percent() : site.getO2C();
        } else if (sc.isVersusIrtam()) {
            value = percent ? site.getO2GW_percent() : site.getO2GW();
        } else {
            throw new RuntimeException("Unknown sites choice");
        }
        return value;
    }
}

