/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

import edu.uml.giro.gambit.core.IonogramScaling;
import edu.uml.giro.gambit.core.LocalDataType;
import java.util.HashMap;

public class LocalDataElements
extends HashMap<Object, Object> {
    public double getObservation() {
        Double value = (Double)this.get((Object)LocalDataType.ALL_OBSERVED_PROCESSED);
        return value == null ? 9999.0 : value;
    }

    public double getRawObservation() {
        Double value = (Double)this.get((Object)LocalDataType.ALL_OBSERVED_RAW);
        return value == null ? 9999.0 : value;
    }

    public int getConfidenceScore() {
        Integer value = (Integer)this.get((Object)LocalDataType.CONFIDENCE_SCORE);
        return value == null ? 51 : value;
    }

    public int getTimegridMismatch() {
        Integer value = (Integer)this.get((Object)LocalDataType.TIMEGRID_MISMATCH_PERCENT);
        return value == null ? 0 : value;
    }

    public int getFlag() {
        Integer value = (Integer)this.get((Object)LocalDataType.FLAG);
        return value == null ? 0 : value;
    }

    public double getClimate() {
        Double value = (Double)this.get((Object)LocalDataType.CLIMATE);
        return value == null ? 9999.0 : value;
    }

    public double getLocalWeather() {
        Double value = (Double)this.get((Object)LocalDataType.LOCAL_WEATHER);
        return value == null ? 9999.0 : value;
    }

    public double getGlobalWeather() {
        Double value = (Double)this.get((Object)LocalDataType.GLOBAL_WEATHER);
        return value == null ? 9999.0 : value;
    }

    public double getO2C() {
        Double value = (Double)this.get((Object)LocalDataType.O2C_DIFFERENCE);
        return value == null ? 9999.0 : value;
    }

    public double getO2C_percent() {
        double value = 9999.0;
        double obs = this.getObservation();
        double climate = this.getClimate();
        if (obs != 9999.0 && climate != 9999.0) {
            value = 100.0 * (obs - climate) / climate;
        }
        return value;
    }

    public double getO2LW() {
        Double value = (Double)this.get((Object)LocalDataType.O2LW_DIFFERENCE);
        return value == null ? 9999.0 : value;
    }

    public double getO2LW_percent() {
        double value = 9999.0;
        double obs = this.getObservation();
        double localWeather = this.getLocalWeather();
        if (obs != 9999.0 && localWeather != 9999.0) {
            value = 100.0 * (obs - localWeather) / localWeather;
        }
        return value;
    }

    public double getO2GW() {
        Double value = (Double)this.get((Object)LocalDataType.O2GW_DIFFERENCE);
        return value == null ? 9999.0 : value;
    }

    public double getO2GW_percent() {
        double value = 9999.0;
        double obs = this.getObservation();
        double globalWeather = this.getGlobalWeather();
        if (obs != 9999.0 && globalWeather != 9999.0) {
            value = 100.0 * (obs - globalWeather) / globalWeather;
        }
        return value;
    }

    public boolean isBetter(double competitionValue, int competitionConfidence, int competitionMismatch) {
        if (IonogramScaling.isMissing(this.getRawObservation())) {
            return false;
        }
        if (competitionValue == 9999.0) {
            return true;
        }
        if (IonogramScaling.isHighQuality(this.getConfidenceScore()) && IonogramScaling.isHighQuality(competitionConfidence)) {
            return this.getTimegridMismatch() < competitionMismatch;
        }
        if (IonogramScaling.isHighQuality(this.getConfidenceScore()) && !IonogramScaling.isHighQuality(competitionConfidence)) {
            return true;
        }
        if (IonogramScaling.isPoorQuality(this.getConfidenceScore()) && !IonogramScaling.isPoorQuality(competitionConfidence)) {
            return false;
        }
        if (IonogramScaling.isTooFar(this.getTimegridMismatch())) {
            return false;
        }
        return this.getTimegridMismatch() < competitionMismatch;
    }
}

