/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

import edu.uml.giro.gambit.core.SitesTypeChoice;
import edu.uml.lgdc.geospace.CharChoice;

public final class SitesChoice
extends Enum<SitesChoice> {
    public static final /* enum */ SitesChoice FOF2_OBSERVATIONS;
    public static final /* enum */ SitesChoice FOF2_DEVIATIONS_CLIMATE;
    public static final /* enum */ SitesChoice FOF2_DEVIATIONS_WEATHER;
    public static final /* enum */ SitesChoice NMF2_OBSERVATIONS;
    public static final /* enum */ SitesChoice NMF2_DEVIATIONS_CLIMATE;
    public static final /* enum */ SitesChoice NMF2_DEVIATIONS_WEATHER;
    public static final /* enum */ SitesChoice HMF2_OBSERVATIONS;
    public static final /* enum */ SitesChoice HMF2_DEVIATIONS_CLIMATE;
    public static final /* enum */ SitesChoice HMF2_DEVIATIONS_WEATHER;
    public static final /* enum */ SitesChoice MUF3000_OBSERVATIONS;
    public static final /* enum */ SitesChoice MUF3000_DEVIATIONS_CLIMATE;
    public static final /* enum */ SitesChoice MUF3000_DEVIATIONS_WEATHER;
    public static final /* enum */ SitesChoice B0_OBSERVATIONS;
    public static final /* enum */ SitesChoice B0_DEVIATIONS_CLIMATE;
    public static final /* enum */ SitesChoice B0_DEVIATIONS_WEATHER;
    public static final /* enum */ SitesChoice B1_OBSERVATIONS;
    public static final /* enum */ SitesChoice B1_DEVIATIONS_CLIMATE;
    public static final /* enum */ SitesChoice B1_DEVIATIONS_WEATHER;
    public static final /* enum */ SitesChoice VTEC_OBSERVATIONS;
    public static final /* enum */ SitesChoice VTEC_DEVIATIONS_CLIMATE;
    public static final /* enum */ SitesChoice VTEC_DEVIATIONS_WEATHER;
    public static final /* enum */ SitesChoice TAU_OBSERVATIONS;
    public static final /* enum */ SitesChoice TAU_DEVIATIONS_CLIMATE;
    public static final /* enum */ SitesChoice TAU_DEVIATIONS_WEATHER;
    public static final /* enum */ SitesChoice CUSTOM_OBSERVATIONS;
    public static final /* enum */ SitesChoice CUSTOM_DEVIATIONS_CLIMATE;
    public static final /* enum */ SitesChoice CUSTOM_DEVIATIONS_WEATHER;
    private final String shortName;
    private final String description;
    private int charIdent;
    private static final /* synthetic */ SitesChoice[] ENUM$VALUES;

    static {
        SitesChoice choice;
        FOF2_OBSERVATIONS = new SitesChoice("foF2: GIRO data", "Observations at GIRO locations", CharChoice.FOF2.getDidbaseIdent());
        FOF2_DEVIATIONS_CLIMATE = new SitesChoice("foF2: observed minus climate", "Difference between measured and IRI-modeled foF2 at GIRO locations", CharChoice.FOF2.getDidbaseIdent());
        FOF2_DEVIATIONS_WEATHER = new SitesChoice("foF2: observed minus weather", "Difference between measured and IRTAM-modeled foF2 at GIRO locations", CharChoice.FOF2.getDidbaseIdent());
        NMF2_OBSERVATIONS = new SitesChoice("NmF2: GIRO data", "Observations at GIRO locations", CharChoice.NMF2.getDidbaseIdent());
        NMF2_DEVIATIONS_CLIMATE = new SitesChoice("NmF2: observed minus climate", "Difference between measured and IRI-modeled NmF2 at GIRO locations", CharChoice.NMF2.getDidbaseIdent());
        NMF2_DEVIATIONS_WEATHER = new SitesChoice("NmF2: observed minus weather", "Difference between measured and IRTAM-modeled NmF2 at GIRO locations", CharChoice.NMF2.getDidbaseIdent());
        HMF2_OBSERVATIONS = new SitesChoice("hmF2: GIRO data", "Observations at GIRO locations", CharChoice.HMF2.getDidbaseIdent());
        HMF2_DEVIATIONS_CLIMATE = new SitesChoice("hmF2: observed minus climate", "Difference between measured and Brunini-modeled hmF2 at GIRO locations", CharChoice.HMF2.getDidbaseIdent());
        HMF2_DEVIATIONS_WEATHER = new SitesChoice("hmF2: observed minus weather", "Difference between measured and IRTAM-modeled hmF2 at GIRO locations", CharChoice.HMF2.getDidbaseIdent());
        MUF3000_OBSERVATIONS = new SitesChoice("MUF3000: GIRO data", "Observations at GIRO locations", CharChoice.MUF3000.getDidbaseIdent());
        MUF3000_DEVIATIONS_CLIMATE = new SitesChoice("MUF3000: observed minus climate", "Difference between measured and IRI-modeled NmF2 at GIRO locations", CharChoice.MUF3000.getDidbaseIdent());
        MUF3000_DEVIATIONS_WEATHER = new SitesChoice("MUF3000: observed minus weather", "Difference between measured and IRTAM-modeled NmF2 at GIRO locations", CharChoice.MUF3000.getDidbaseIdent());
        B0_OBSERVATIONS = new SitesChoice("B0: GIRO data", "Observations at GIRO locations", CharChoice.B0.getDidbaseIdent());
        B0_DEVIATIONS_CLIMATE = new SitesChoice("B0: observed minus climate", "Difference between measured and IRI-modeled B0 at GIRO locations", CharChoice.B0.getDidbaseIdent());
        B0_DEVIATIONS_WEATHER = new SitesChoice("B0: observed minus weather", "Difference between measured and IRTAM-modeled B0 at GIRO locations", CharChoice.B0.getDidbaseIdent());
        B1_OBSERVATIONS = new SitesChoice("B1: GIRO data", "Observations at GIRO locations", CharChoice.B1.getDidbaseIdent());
        B1_DEVIATIONS_CLIMATE = new SitesChoice("B1: observed minus climate", "Difference between measured and IRI-modeled B0 at GIRO locations", CharChoice.B1.getDidbaseIdent());
        B1_DEVIATIONS_WEATHER = new SitesChoice("B1: observed minus weather", "Difference between measured and IRTAM-modeled B0 at GIRO locations", CharChoice.B1.getDidbaseIdent());
        VTEC_OBSERVATIONS = new SitesChoice("VTEC: GNSS data", "Observations at GNSS locations", CharChoice.VTEC.getDidbaseIdent());
        VTEC_DEVIATIONS_CLIMATE = new SitesChoice("TEC: observed minus climate", "Difference between measured and 30-day average TEC at GNSS locations", CharChoice.VTEC.getDidbaseIdent());
        VTEC_DEVIATIONS_WEATHER = new SitesChoice("TEC: observed minus weather", "Difference between measured and 30-day average TEC at GNSS locations", CharChoice.VTEC.getDidbaseIdent());
        TAU_OBSERVATIONS = new SitesChoice("Slab Thickness: GIRO+GNSS data", "Observations at GNSS locations", CharChoice.TAU.getDidbaseIdent());
        TAU_DEVIATIONS_CLIMATE = new SitesChoice("Slab Thickness: observed minus climate", "Difference between measured and average tau at GNSS locations", CharChoice.TAU.getDidbaseIdent());
        TAU_DEVIATIONS_WEATHER = new SitesChoice("Slab Thickness: observed minus weather", "Difference between measured and average tau at GNSS locations", CharChoice.TAU.getDidbaseIdent());
        CUSTOM_OBSERVATIONS = new SitesChoice("CUSTOM: GIRO data", "Observations at GIRO locations", CharChoice.getByName("Custom").getDidbaseIdent());
        CUSTOM_DEVIATIONS_CLIMATE = new SitesChoice("CUSTOM: observed minus climate", "Difference between measured and IRI-modeled B0 at GIRO locations", CharChoice.getByName("Custom").getDidbaseIdent());
        CUSTOM_DEVIATIONS_WEATHER = new SitesChoice("CUSTOM: observed minus weather", "Difference between measured and IRTAM-modeled B0 at GIRO locations", CharChoice.getByName("Custom").getDidbaseIdent());
        ENUM$VALUES = new SitesChoice[]{FOF2_OBSERVATIONS, FOF2_DEVIATIONS_CLIMATE, FOF2_DEVIATIONS_WEATHER, NMF2_OBSERVATIONS, NMF2_DEVIATIONS_CLIMATE, NMF2_DEVIATIONS_WEATHER, HMF2_OBSERVATIONS, HMF2_DEVIATIONS_CLIMATE, HMF2_DEVIATIONS_WEATHER, MUF3000_OBSERVATIONS, MUF3000_DEVIATIONS_CLIMATE, MUF3000_DEVIATIONS_WEATHER, B0_OBSERVATIONS, B0_DEVIATIONS_CLIMATE, B0_DEVIATIONS_WEATHER, B1_OBSERVATIONS, B1_DEVIATIONS_CLIMATE, B1_DEVIATIONS_WEATHER, VTEC_OBSERVATIONS, VTEC_DEVIATIONS_CLIMATE, VTEC_DEVIATIONS_WEATHER, TAU_OBSERVATIONS, TAU_DEVIATIONS_CLIMATE, TAU_DEVIATIONS_WEATHER, CUSTOM_OBSERVATIONS, CUSTOM_DEVIATIONS_CLIMATE, CUSTOM_DEVIATIONS_WEATHER};
        boolean[] isMapTypeDefined = new boolean[SitesChoice.values().length];
        int iChoice = 0;
        SitesChoice[] sitesChoiceArray = SitesChoice.values();
        int n = sitesChoiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            choice = sitesChoiceArray[n2];
            isMapTypeDefined[iChoice] = false;
            isMapTypeDefined[iChoice] = SitesChoice.isVersusIrtam(choice) || SitesChoice.isVersusEmpericelModel(choice) || SitesChoice.isObservations(choice);
            ++iChoice;
            ++n2;
        }
        iChoice = 0;
        sitesChoiceArray = SitesChoice.values();
        n = sitesChoiceArray.length;
        n2 = 0;
        while (n2 < n) {
            choice = sitesChoiceArray[n2];
            if (!isMapTypeDefined[iChoice]) {
                throw new RuntimeException("Type is not defined for " + choice.toString() + ". In SiteChoice.");
            }
            ++iChoice;
            ++n2;
        }
        CharChoice[] charChoiceArray = CharChoice.values();
        int n3 = charChoiceArray.length;
        int n4 = 0;
        while (n4 < n3) {
            CharChoice cc = charChoiceArray[n4];
            SitesTypeChoice[] sitesTypeChoiceArray = SitesTypeChoice.values();
            int n5 = sitesTypeChoiceArray.length;
            int n6 = 0;
            while (n6 < n5) {
                SitesTypeChoice stc = sitesTypeChoiceArray[n6];
                if (SitesChoice.getSiteChoice(cc, stc) == null && !cc.equals((Object)CharChoice.CUSTOM)) {
                    throw new RuntimeException("Define SiteChoice for CharChoice " + cc.name() + " and SiteTypeChoice " + stc.name());
                }
                ++n6;
            }
            ++n4;
        }
    }

    private SitesChoice(String shortName, String description, int charIdent) {
        this.shortName = shortName;
        this.description = description;
        this.charIdent = charIdent;
    }

    public static SitesChoice getSiteChoice(CharChoice cc, SitesTypeChoice stc) {
        try {
            return SitesChoice.valueOf(String.valueOf(cc.name()) + "_" + stc.name());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String shortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public CharChoice getCC() {
        return CharChoice.getByIdent(this.charIdent);
    }

    private static boolean isVersusIrtam(SitesChoice choice) {
        return choice == FOF2_DEVIATIONS_WEATHER || choice == NMF2_DEVIATIONS_WEATHER || choice == HMF2_DEVIATIONS_WEATHER || choice == MUF3000_DEVIATIONS_WEATHER || choice == B0_DEVIATIONS_WEATHER || choice == B1_DEVIATIONS_WEATHER || choice == VTEC_DEVIATIONS_WEATHER || choice == TAU_DEVIATIONS_WEATHER || choice == CUSTOM_DEVIATIONS_WEATHER;
    }

    public boolean isVersusIrtam() {
        return SitesChoice.isVersusIrtam(this);
    }

    private static boolean isVersusEmpericelModel(SitesChoice choice) {
        return choice == FOF2_DEVIATIONS_CLIMATE || choice == NMF2_DEVIATIONS_CLIMATE || choice == HMF2_DEVIATIONS_CLIMATE || choice == MUF3000_DEVIATIONS_CLIMATE || choice == B0_DEVIATIONS_CLIMATE || choice == B1_DEVIATIONS_CLIMATE || choice == VTEC_DEVIATIONS_CLIMATE || choice == TAU_DEVIATIONS_CLIMATE || choice == CUSTOM_DEVIATIONS_CLIMATE;
    }

    public boolean isVersusEmpiricalModel() {
        return SitesChoice.isVersusEmpericelModel(this);
    }

    private static boolean isObservations(SitesChoice choice) {
        return choice == FOF2_OBSERVATIONS || choice == NMF2_OBSERVATIONS || choice == HMF2_OBSERVATIONS || choice == MUF3000_OBSERVATIONS || choice == B0_OBSERVATIONS || choice == B1_OBSERVATIONS || choice == VTEC_OBSERVATIONS || choice == TAU_OBSERVATIONS || choice == CUSTOM_OBSERVATIONS;
    }

    public boolean isObservations() {
        return SitesChoice.isObservations(this);
    }

    public static int length() {
        return SitesChoice.values().length;
    }

    public static SitesChoice get(int ordinal) {
        if (SitesChoice.check(ordinal)) {
            return SitesChoice.values()[ordinal];
        }
        throw new IllegalArgumentException("Illegal SitesChoice ordinal, " + ordinal);
    }

    public static String[] shortNames(boolean initialCaps) {
        SitesChoice[] values = SitesChoice.values();
        String[] shortNames = new String[values.length];
        int i = 0;
        while (i < values.length) {
            shortNames[i] = values[i].shortName;
            ++i;
        }
        return shortNames;
    }

    public static boolean check(int value) {
        return value >= 0 && value < SitesChoice.values().length;
    }

    public static SitesChoice[] values() {
        SitesChoice[] sitesChoiceArray = ENUM$VALUES;
        int n = sitesChoiceArray.length;
        SitesChoice[] sitesChoiceArray2 = new SitesChoice[n];
        System.arraycopy(ENUM$VALUES, 0, sitesChoiceArray2, 0, n);
        return sitesChoiceArray2;
    }

    public static SitesChoice valueOf(String string) {
        return Enum.valueOf(SitesChoice.class, string);
    }
}

