/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.database;

import edu.uml.giro.gambit.core.LocalDataType;
import edu.uml.lgdc.geospace.CharChoice;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlobContent {
    InputStream[] globalWeather = new InputStream[CharChoice.SIZE];
    InputStream[] obs = new InputStream[CharChoice.SIZE];
    List<Map> localWeather = new ArrayList<Map>();

    public BlobContent() {
        CharChoice[] charChoiceArray = CharChoice.values();
        int n = charChoiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            CharChoice cc = charChoiceArray[n2];
            this.localWeather.add(new HashMap());
            ++n2;
        }
    }

    boolean isAvailable(CharChoice cc, LocalDataType type) {
        int i = cc.getIndex();
        switch (type) {
            case GLOBAL_WEATHER: {
                return this.globalWeather[i] != null;
            }
            case LOCAL_WEATHER: {
                return !this.localWeather.get(i).isEmpty();
            }
            case ALL_OBSERVED_PROCESSED: {
                return this.obs[i] != null;
            }
        }
        return false;
    }

    public void setGlobalWeatherStream(CharChoice cc, InputStream inputStream) {
        this.globalWeather[cc.getIndex()] = inputStream;
    }

    public void setObsStream(CharChoice cc, InputStream inputStream) {
        this.obs[cc.getIndex()] = inputStream;
    }

    public void addLocalWeatherCoeffs(CharChoice cc, String ursiCode, double[] coeffs) {
        this.localWeather.get(cc.getIndex()).put(ursiCode, coeffs);
    }

    public InputStream getGlobalWeatherStream(CharChoice cc) {
        return this.globalWeather[cc.getIndex()];
    }

    public InputStream getObservationStream(CharChoice cc) {
        return this.obs[cc.getIndex()];
    }

    public Map<String, double[]> getLocalWeather(CharChoice cc) {
        return this.localWeather.get(cc.getIndex());
    }
}

