/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FrameFactory;
import gov.nasa.worldwind.render.GlobeAnnotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.nio.DoubleBuffer;
import javax.media.opengl.GL2;

public class GAMBITAnnotations {
    public static AnnotationAttributes getCirclesSitesAttributes() {
        AnnotationAttributes dataSitesAttributes = new AnnotationAttributes();
        dataSitesAttributes.setLeader("gov.nasa.worldwind.avkey.ShapeNone");
        dataSitesAttributes.setDrawOffset(new Point(0, -8));
        dataSitesAttributes.setSize(new Dimension(16, 16));
        dataSitesAttributes.setBorderWidth(0.0);
        dataSitesAttributes.setCornerRadius(0);
        dataSitesAttributes.setBackgroundColor(new Color(0, 0, 0, 0));
        return dataSitesAttributes;
    }

    public static class SitesCirclesAnnotation
    extends GlobeAnnotation {
        private DoubleBuffer shapeBuffer;

        public SitesCirclesAnnotation(Position position, AnnotationAttributes defaults) {
            super("", position, defaults);
        }

        protected void applyScreenTransform(DrawContext dc, int x, int y, int width, int height, double scale) {
            double finalScale = scale * this.computeScale(dc);
            GL2 gl = dc.getGL().getGL2();
            gl.glTranslated((double)x, (double)y, 0.0);
            gl.glScaled(finalScale, finalScale, 1.0);
        }

        protected void doDraw(DrawContext dc, int width, int height, double opacity, Position pickPosition) {
            if (dc.isPickingMode()) {
                this.bindPickableObject(dc, pickPosition);
            }
            this.applyColor(dc, this.getAttributes().getTextColor(), 1.0, true);
            int size = 32;
            if (this.shapeBuffer == null) {
                this.shapeBuffer = FrameFactory.createShapeBuffer((String)"gov.nasa.worldwind.avkey.ShapeEllipse", (double)size, (double)size, (int)0, null);
            }
            dc.getGL().getGL2().glTranslated((double)(-size / 2), (double)(-size / 2), 0.0);
            FrameFactory.drawBuffer((DrawContext)dc, (int)6, (DoubleBuffer)this.shapeBuffer);
        }
    }
}

