/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.SitesChoice;
import edu.uml.giro.gambit.display.ColorLegend;
import edu.uml.giro.gambit.display.WWindowManager;
import edu.uml.lgdc.geospace.MapChoice;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurfaceLegend;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.text.DecimalFormat;

public class GAMBITLegends {
    public AnalyticSurfaceLegend dataSurfaceLegend = null;
    public AnalyticSurfaceLegend sitesLegend = null;
    public Point legendPosition = new Point(0, 0);
    private RenderableLayer surfaceLayer = null;
    private RenderableLayer sitesLayer = null;
    private RenderableLayer externalSurfaceLayer = null;

    public GAMBITLegends(RenderableLayer surfaceLayer, RenderableLayer sitesLayer, RenderableLayer externalSurfaceLayer) {
        this.surfaceLayer = surfaceLayer;
        this.sitesLayer = sitesLayer;
        this.externalSurfaceLayer = externalSurfaceLayer;
    }

    public void buildSurfaceLegend(WorldWindow wwd, RenderableLayer layer, double minValue, double maxValue, String[] labels, boolean regimeRecurrentProcessing, int yOffset, Color color, MapChoice mapChoice, int items) {
        if (layer != this.surfaceLayer && layer != this.externalSurfaceLayer) {
            throw new RuntimeException();
        }
        String[] lbls = labels == null ? GAMBITLegends.getMapLegendLabels(mapChoice) : labels;
        int xOffset = 0;
        if (items == 2) {
            int n = xOffset = mapChoice.isExternalMap() ? 120 : -120;
        }
        if (items == 3) {
            int n = xOffset = mapChoice.isExternalMap() ? 210 : -210;
        }
        if (regimeRecurrentProcessing) {
            xOffset += 5;
        }
        WWindowManager.removeLegend(this.dataSurfaceLegend, layer);
        this.dataSurfaceLegend = GAMBITLegends.createColorLegend(minValue, maxValue, lbls, layer, color);
        this.legendPosition = this.placeLegend(wwd, this.dataSurfaceLegend, xOffset, yOffset);
        layer.addRenderable((Renderable)this.dataSurfaceLegend);
    }

    public Point placeLegend(WorldWindow wwd, AnalyticSurfaceLegend legend, int xOffset, int yOffset) {
        int wwdHeight = ((Component)wwd).getHeight();
        int wwdWidth = ((Component)wwd).getWidth();
        Point position = new Point(0, 0);
        position.x = wwdWidth / 2 + xOffset;
        position.y = wwdHeight - 50 + yOffset;
        legend.setScreenLocation(position);
        return position;
    }

    public void buildCirclesLegend(WorldWindow wwd, RenderableLayer layer, double minValue, double maxValue, boolean regimeRecurrentProcessing, Color color, SitesChoice sitesChoice, MapChoice mapChoice, boolean externalMap, int items) {
        if (layer != this.sitesLayer) {
            throw new RuntimeException();
        }
        int xOffset = 0;
        if (items == 2) {
            int n = xOffset = externalMap ? -120 : 120;
        }
        if (regimeRecurrentProcessing) {
            xOffset += 5;
        }
        WWindowManager.removeLegend(this.sitesLegend, layer);
        this.sitesLegend = GAMBITLegends.createColorLegend(minValue, maxValue, GAMBITLegends.getSitesLegendLabels(sitesChoice, mapChoice.isPercentDeltaMap()), layer, color);
        this.legendPosition = this.placeLegend(wwd, this.sitesLegend, xOffset, 0);
        layer.addRenderable((Renderable)this.sitesLegend);
    }

    public static String[] getMapLegendLabels(MapChoice mapChoice) {
        String legendLabel = "";
        String legendLabelFormat = "#.#";
        switch (mapChoice) {
            case FOF2_CLIMATE: {
                legendLabel = "foF2 (IRI) MHz";
                legendLabelFormat = "#.#";
                break;
            }
            case FOF2_MEDIAN_30DAY: {
                legendLabel = "foF2 (30-day) MHz";
                legendLabelFormat = "#.#";
                break;
            }
            case GK: {
                legendLabel = "GK";
                legendLabelFormat = "#.#";
                break;
            }
            case FOF2_INTERPOL_DC: {
                break;
            }
            case FOF2_FITTED_DC: {
                break;
            }
            case FOF2_GKFITERROR_DC: {
                break;
            }
            case HMF2_INTERPOL_DC: {
                break;
            }
            case HMF2_FITTED_DC: {
                break;
            }
            case HMF2_GKFITERROR_DC: {
                break;
            }
            case FOF2_WEATHER: {
                legendLabel = "foF2 (IRTAM) MHz";
                legendLabelFormat = "#.#";
                break;
            }
            case FOF2_DELTA: {
                legendLabel = "foF2 (IRTAM-IRI) MHz";
                legendLabelFormat = "#.#";
                break;
            }
            case FOF2_DELTA_PERCENT: {
                legendLabel = "Delta-foF2 %";
                legendLabelFormat = "#";
                break;
            }
            case HMF2_CLIMATE: {
                legendLabel = "hmF2 (Brunini) km";
                legendLabelFormat = "#.#";
                break;
            }
            case HMF2_MEDIAN_30DAY: {
                legendLabel = "hmF2 (30-day) km";
                legendLabelFormat = "#.#";
                break;
            }
            case HMF2_WEATHER: {
                legendLabel = "hmF2 (IRTAM) km";
                legendLabelFormat = "#.#";
                break;
            }
            case HMF2_DELTA: {
                legendLabel = "Delta-hmF2 km";
                legendLabelFormat = "#.#";
                break;
            }
            case HMF2_DELTA_PERCENT: {
                legendLabel = "Delta-hmF2 %";
                legendLabelFormat = "#";
                break;
            }
            case NMF2_CLIMATE: {
                legendLabel = "NmF2, cm-3";
                legendLabelFormat = "#.#";
                break;
            }
            case NMF2_MEDIAN_30DAY: {
                legendLabel = "NmF2 (30-day) cm-3";
                legendLabelFormat = "#.#";
                break;
            }
            case NMF2_WEATHER: {
                legendLabel = "NmF2 (IRTAM) cm-3";
                legendLabelFormat = "#.#";
                break;
            }
            case NMF2_DELTA: {
                legendLabel = "Delta-NmF2 cm-3";
                legendLabelFormat = "#.#";
                break;
            }
            case NMF2_DELTA_PERCENT: {
                legendLabel = "Delta-NmF2 %";
                legendLabelFormat = "#";
                break;
            }
            case MUF3000_CLIMATE: {
                legendLabel = "MUF3000 (IRI) MHz";
                legendLabelFormat = "#.#";
                break;
            }
            case MUF3000_MEDIAN_30DAY: {
                legendLabel = "MUF3000 30-day, MHz";
                legendLabelFormat = "#.#";
                break;
            }
            case MUF3000_WEATHER: {
                legendLabel = "MUF3000 (IRTAM) MHz";
                legendLabelFormat = "#.#";
                break;
            }
            case MUF3000_DELTA: {
                legendLabel = "Delta-MUF3000 MHz";
                legendLabelFormat = "#.#";
                break;
            }
            case MUF3000_DELTA_PERCENT: {
                legendLabel = "Delta-MUF3000 %";
                legendLabelFormat = "#";
                break;
            }
            case B0_CLIMATE: {
                legendLabel = "B0 (IRI), km";
                legendLabelFormat = "#.#";
                break;
            }
            case B0_MEDIAN_30DAY: {
                legendLabel = "B0 (30-day), km";
                legendLabelFormat = "#.#";
                break;
            }
            case B0_WEATHER: {
                legendLabel = "B0 (IRTAM) km";
                legendLabelFormat = "#.#";
                break;
            }
            case B0_DELTA: {
                legendLabel = "Delta-B0 km";
                legendLabelFormat = "#.#";
                break;
            }
            case B0_DELTA_PERCENT: {
                legendLabel = "Delta-B0 %";
                legendLabelFormat = "#";
                break;
            }
            case B1_CLIMATE: {
                legendLabel = "B1 (IRI), km";
                legendLabelFormat = "#.#";
                break;
            }
            case B1_MEDIAN_30DAY: {
                legendLabel = "B1 (30-day), km";
                legendLabelFormat = "#.#";
                break;
            }
            case B1_WEATHER: {
                legendLabel = "B1 (IRTAM) km";
                legendLabelFormat = "#.#";
                break;
            }
            case B1_DELTA: {
                legendLabel = "Delta-B1 km";
                legendLabelFormat = "#.#";
                break;
            }
            case B1_DELTA_PERCENT: {
                legendLabel = "Delta-B1 %";
                legendLabelFormat = "#";
                break;
            }
            case VTEC_CLIMATE: 
            case VTEC_MEDIAN_30DAY: {
                legendLabel = "VTEC-average TECU";
                legendLabelFormat = "#.#";
                break;
            }
            case VTEC_WEATHER: {
                legendLabel = "VTEC (IGS) TECU";
                legendLabelFormat = "#.#";
                break;
            }
            case VTEC_DELTA: {
                legendLabel = "Delta-VTEC TECU";
                legendLabelFormat = "#";
                break;
            }
            case VTEC_DELTA_PERCENT: {
                legendLabel = "Delta-VTEC %";
                legendLabelFormat = "#";
                break;
            }
            case TAU_CLIMATE: 
            case TAU_MEDIAN_30DAY: {
                legendLabel = "TAU-average km";
                legendLabelFormat = "#";
                break;
            }
            case TAU_WEATHER: {
                legendLabel = "TAU (GIRO&GNSS) km";
                legendLabelFormat = "#";
                break;
            }
            case TAU_DELTA: {
                legendLabel = "Delta-TAU km";
                legendLabelFormat = "#";
                break;
            }
            case TAU_DELTA_PERCENT: {
                legendLabel = "Delta-TAU %";
                legendLabelFormat = "#";
                break;
            }
            case EVTEC_GPS: {
                legendLabel = "VTEC, TECU";
                legendLabelFormat = "#.#";
                break;
            }
            case EVTEC_GPS_DELTA: {
                legendLabel = "Delta-VTEC, TECU";
                legendLabelFormat = "#.#";
                break;
            }
            case EVTEC_GPS_DELTA_PERCENT: {
                legendLabel = "Delta-VTEC, %";
                legendLabelFormat = "#";
                break;
            }
            case ESLAB_THICKNESS: {
                legendLabel = "Slab thickness, km";
                legendLabelFormat = "#";
                break;
            }
            case ESLAB_THICKNESS_DELTA: {
                legendLabel = "Slab thickness delta, km";
                legendLabelFormat = "#";
                break;
            }
            case ESLAB_THICKNESS_DELTA_PERCENT: {
                legendLabel = "Slab thickness delta, %";
                legendLabelFormat = "#";
            }
        }
        String[] legendLabelAttr = new String[]{"Map: " + legendLabel, legendLabelFormat};
        return legendLabelAttr;
    }

    public static String[] getSitesLegendLabels(SitesChoice sitesChoice, boolean isPercentDelta) {
        String[] legendLabelAttrs = new String[2];
        switch (sitesChoice) {
            case FOF2_OBSERVATIONS: {
                legendLabelAttrs[0] = "Sites: foF2 (GIRO) MHz";
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case FOF2_DEVIATIONS_CLIMATE: {
                legendLabelAttrs[0] = "Sites: foF2 (GIRO-IRI) MHz";
                if (isPercentDelta) {
                    legendLabelAttrs[0] = "Sites: foF2 (GIRO-IRI)/IRI %";
                }
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case FOF2_DEVIATIONS_WEATHER: {
                legendLabelAttrs[0] = "Sites: foF2 (GIRO-IRTAM) MHz";
                if (isPercentDelta) {
                    legendLabelAttrs[0] = "Sites: foF2 (GIRO-IRTAM)/IRTAM %";
                }
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case NMF2_OBSERVATIONS: {
                legendLabelAttrs[0] = "Sites: NmF2 (GIRO) cm-3";
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case NMF2_DEVIATIONS_CLIMATE: {
                legendLabelAttrs[0] = "Sites: NmF2 (GIRO-IRI) cm-3";
                if (isPercentDelta) {
                    legendLabelAttrs[0] = "Sites: NmF2 (GIRO-IRI)/IRI %";
                }
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case NMF2_DEVIATIONS_WEATHER: {
                legendLabelAttrs[0] = "Sites: NmF2 (GIRO-IRTAM) cm-3";
                if (isPercentDelta) {
                    legendLabelAttrs[0] = "Sites: NmF2 (GIRO-IRTAM)/IRTAM %";
                }
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case HMF2_OBSERVATIONS: {
                legendLabelAttrs[0] = "Sites: hmF2 (GIRO) km";
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case HMF2_DEVIATIONS_CLIMATE: {
                legendLabelAttrs[0] = "Sites: hmF2 (GIRO-Brunini) km";
                if (isPercentDelta) {
                    legendLabelAttrs[0] = "Sites: hmF2 (GIRO-Brunini)/Brunini %";
                }
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case HMF2_DEVIATIONS_WEATHER: {
                legendLabelAttrs[0] = "Sites: hmF2 (GIRO-IRTAM) km";
                if (isPercentDelta) {
                    legendLabelAttrs[0] = "Sites: hmF2 (GIRO-IRTAM)/IRTAM %";
                }
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case MUF3000_OBSERVATIONS: {
                legendLabelAttrs[0] = "MUF3000: foF2 (GIRO) MHz";
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case MUF3000_DEVIATIONS_CLIMATE: {
                legendLabelAttrs[0] = "Sites: MUF3000 (GIRO-IRI) MHz";
                if (isPercentDelta) {
                    legendLabelAttrs[0] = "Sites: MUF3000 (GIRO-IRI)/IRI %";
                }
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case MUF3000_DEVIATIONS_WEATHER: {
                legendLabelAttrs[0] = "Sites: MUF3000 (GIRO-IRTAM) MHz";
                if (isPercentDelta) {
                    legendLabelAttrs[0] = "Sites: MUF3000 (GIRO-IRTAM)/IRTAM %";
                }
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case B0_OBSERVATIONS: {
                legendLabelAttrs[0] = "Sites: B0 (GIRO) km";
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case B0_DEVIATIONS_CLIMATE: {
                legendLabelAttrs[0] = "Sites: B0 (GIRO-IRI) km";
                if (isPercentDelta) {
                    legendLabelAttrs[0] = "Sites: B0 (GIRO-IRI)/IRI %";
                }
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case B0_DEVIATIONS_WEATHER: {
                legendLabelAttrs[0] = "Sites: B0 (GIRO-IRTAM) km";
                if (isPercentDelta) {
                    legendLabelAttrs[0] = "Sites: B0 (GIRO-IRTAM)/IRTAM %";
                }
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case B1_OBSERVATIONS: {
                legendLabelAttrs[0] = "Sites: B1 (GIRO)";
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case B1_DEVIATIONS_CLIMATE: {
                legendLabelAttrs[0] = "Sites: B1 (GIRO-IRI)";
                if (isPercentDelta) {
                    legendLabelAttrs[0] = "Sites: B1 (GIRO-IRI)/IRI %";
                }
                legendLabelAttrs[1] = "#.#";
                break;
            }
            case B1_DEVIATIONS_WEATHER: {
                legendLabelAttrs[0] = "Sites: B1 (GIRO-IRTAM) km";
                if (isPercentDelta) {
                    legendLabelAttrs[0] = "Sites: B1d (GIRO-IRTAM)/IRTAM %";
                }
                legendLabelAttrs[1] = "#.#";
            }
        }
        return legendLabelAttrs;
    }

    public static AnalyticSurfaceLegend createColorLegend(double minValue, double maxValue, String[] legendLabelAttr, RenderableLayer layer, Color color) {
        int exponent;
        String legendLabel = legendLabelAttr[0];
        double range = maxValue - minValue;
        int n = exponent = range > 0.0 ? (int)Math.log10(range) : 0;
        if (exponent > -3 && exponent < 3 || maxValue < 3000.0 && minValue > -3000.0) {
            exponent = 0;
        }
        if (exponent != 0 && exponent > 0) {
            legendLabel = String.valueOf(legendLabel) + ", x10" + (exponent > 0 ? "+" : "") + exponent;
        }
        DecimalFormat legendLabelFormat = new DecimalFormat(legendLabelAttr[1]);
        ColorLegend legend = ColorLegend.fromColorGradient(170, 50, minValue, maxValue, 0.6666666666666666, 0.0, Color.black, ColorLegend.createDefaultColorGradientLabels(minValue, maxValue, legendLabelFormat, GambitConstants.COLOR_LEGEND_DEFAULT_FONT, color, exponent), ColorLegend.createLegendLabelAttributes((double)0.0, (String)legendLabel, (Font)GambitConstants.COLOR_LEGEND_DEFAULT_FONT, (Color)color, (double)0.0, (double)-20.0));
        legend.setOpacity(0.8);
        return legend;
    }

    public static AnalyticSurfaceLegend createDateLegend(WorldWindow wwd, String dateLabel, int currentViewType, Color color) {
        int wwdWidth = ((Component)wwd).getWidth();
        ColorLegend legend = ColorLegend.fromColorGradient(1, 1, 0.0, 0.0, 0.6666666666666666, 0.0, Color.black, null, AnalyticSurfaceLegend.createLegendLabelAttributes((double)0.0, (String)dateLabel, (Font)GambitConstants.LEGEND_DEFAULT_FONT, (Color)color, (double)0.0, (double)-20.0));
        legend.setOpacity(0.8);
        int legendXLength = 360;
        int legendYOffset = 30;
        if (currentViewType == 0) {
            legend.setScreenLocation(new Point(wwdWidth - legendXLength, legendYOffset));
        }
        if (currentViewType == 2) {
            legend.setScreenLocation(new Point(wwdWidth - legendXLength, legendYOffset + 75));
        }
        return legend;
    }

    public static AnalyticSurfaceLegend createStringLegend(WorldWindow wwd, String dateLabel, int xOffset, boolean isLeftAligned, int yOffset, boolean isTopAligned, int currentViewType, Color color) {
        int realXPosition = 0;
        int realYPosition = 0;
        int realWidth = ((Component)wwd).getWidth();
        int realHeight = ((Component)wwd).getHeight();
        if (currentViewType == 2) {
            realXPosition = 92;
            realYPosition = 75;
            realWidth = 500;
            realHeight = 360;
        }
        Point position = new Point(realXPosition + xOffset, realYPosition + yOffset);
        if (!isLeftAligned) {
            position.setLocation(realXPosition + realWidth - xOffset, position.y);
        }
        if (!isTopAligned) {
            position.setLocation(position.x, realYPosition + realHeight - yOffset);
        }
        ColorLegend legend = ColorLegend.fromColorGradient(1, 1, 0.0, 0.0, 0.6666666666666666, 0.0, Color.black, null, AnalyticSurfaceLegend.createLegendLabelAttributes((double)0.0, (String)dateLabel, (Font)GambitConstants.LEGEND_DEFAULT_FONT, (Color)color, (double)0.0, (double)-20.0));
        legend.setOpacity(0.8);
        legend.setScreenLocation(position);
        return legend;
    }
}

