/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.project.settings.ContentType;
import edu.uml.lgdc.project.settings.OptionDesc;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.SectionDescriptor;
import java.util.HashMap;
import java.util.Map;

public class GambitColorscaleSettings
extends SectionDescriptor<GambitColorscaleSettings>
implements Cloneable {
    public static final String SECTION_NAME = "Custom Color Scales";
    private static final String OPTION_CUSTOM_FOF2 = "Custom_foF2_MHz";
    private static final String OPTION_CUSTOM_NMF2 = "Custom_NmF2_cm3";
    private static final String OPTION_CUSTOM_HMF2 = "Custom_hmF2_km";
    private static final String OPTION_CUSTOM_MUF3000 = "Custom_MUF3000_MHz";
    private static final String OPTION_CUSTOM_B0 = "Custom_B0_km";
    private static final String OPTION_CUSTOM_B1 = "Custom_B1";
    private static final String OPTION_CUSTOM_VTEC = "Custom_TEC_TECU";
    private static final String OPTION_CUSTOM_TAU = "Custom_TAU_km";
    private static final String OPTION_DELTA_FOF2 = "Delta_foF2_MHz";
    private static final String OPTION_DELTA_NMF2 = "Delta_NmF2_cm3";
    private static final String OPTION_DELTA_HMF2 = "Delta_hmF2_km";
    private static final String OPTION_DELTA_MUF3000 = "Delta_MUF3000_MHz";
    private static final String OPTION_DELTA_B0 = "Delta_B0_km";
    private static final String OPTION_DELTA_B1 = "Delta_B1";
    private static final String OPTION_DELTA_VTEC = "Delta_TEC_TECU";
    private static final String OPTION_DELTA_TAU = "Delta_TAU_km";
    private static final String OPTION_PERCENT_FOF2 = "Percent_foF2_MHz";
    private static final String OPTION_PERCENT_NMF2 = "Percent_NmF2_cm3";
    private static final String OPTION_PERCENT_HMF2 = "Percent_hmF2_km";
    private static final String OPTION_PERCENT_MUF3000 = "Percent_MUF3000_MHz";
    private static final String OPTION_PERCENT_B0 = "Percent_B0_km";
    private static final String OPTION_PERCENT_B1 = "Percent_B1";
    private static final String OPTION_PERCENT_VTEC = "Percent_TEC_TECU";
    private static final String OPTION_PERCENT_TAU = "Percent_TAU_km";
    private static final String OPTION_COLORSCALE_ADJUST = "ColorscaleAdjust";
    private Map<CharChoice, double[]> custom = new HashMap<CharChoice, double[]>();
    private Map<CharChoice, double[]> delta = new HashMap<CharChoice, double[]>();
    private Map<CharChoice, double[]> percent = new HashMap<CharChoice, double[]>();
    private double adjust = 1.0;
    protected final Map<String, OptionDesc> descriptor = new HashMap<String, OptionDesc>(32);

    public GambitColorscaleSettings() {
        this.setDefaults();
        this.fillDescriptor();
    }

    protected void setDefaults() {
        this.custom.put(CharChoice.FOF2, new double[]{2.0, 12.0});
        this.custom.put(CharChoice.NMF2, new double[]{50000.0, 4000000.0});
        this.custom.put(CharChoice.HMF2, new double[]{200.0, 500.0});
        this.custom.put(CharChoice.MUF3000, new double[]{3.0, 30.0});
        this.custom.put(CharChoice.B0, new double[]{50.0, 300.0});
        this.custom.put(CharChoice.B1, new double[]{1.0, 5.0});
        this.custom.put(CharChoice.VTEC, new double[]{0.0, 60.0});
        this.custom.put(CharChoice.TAU, new double[]{150.0, 400.0});
        this.delta.put(CharChoice.FOF2, new double[]{-3.0, 3.0});
        this.delta.put(CharChoice.NMF2, new double[]{-5000.0, 5000.0});
        this.delta.put(CharChoice.HMF2, new double[]{-50.0, 50.0});
        this.delta.put(CharChoice.MUF3000, new double[]{-3.0, 3.0});
        this.delta.put(CharChoice.B0, new double[]{-30.0, 30.0});
        this.delta.put(CharChoice.B1, new double[]{-1.0, 1.0});
        this.delta.put(CharChoice.VTEC, new double[]{-10.0, 10.0});
        this.delta.put(CharChoice.TAU, new double[]{-40.0, 40.0});
        this.percent.put(CharChoice.FOF2, new double[]{-100.0, 100.0});
        this.percent.put(CharChoice.NMF2, new double[]{-100.0, 100.0});
        this.percent.put(CharChoice.HMF2, new double[]{-100.0, 100.0});
        this.percent.put(CharChoice.MUF3000, new double[]{-100.0, 100.0});
        this.percent.put(CharChoice.B0, new double[]{-100.0, 100.0});
        this.percent.put(CharChoice.B1, new double[]{-100.0, 100.0});
        this.percent.put(CharChoice.VTEC, new double[]{-100.0, 100.0});
        this.percent.put(CharChoice.TAU, new double[]{-100.0, 100.0});
    }

    @Override
    protected void fillDescriptor() {
        this.descriptor.put(OPTION_CUSTOM_FOF2, new OptionDesc((Object)this.percent.get((Object)CharChoice.FOF2), ContentType.DISPLAY));
        this.descriptor.put(OPTION_CUSTOM_NMF2, new OptionDesc((Object)this.percent.get((Object)CharChoice.NMF2), ContentType.DISPLAY));
        this.descriptor.put(OPTION_CUSTOM_HMF2, new OptionDesc((Object)this.percent.get((Object)CharChoice.HMF2), ContentType.DISPLAY));
        this.descriptor.put(OPTION_CUSTOM_MUF3000, new OptionDesc((Object)this.percent.get((Object)CharChoice.MUF3000), ContentType.DISPLAY));
        this.descriptor.put(OPTION_CUSTOM_B0, new OptionDesc((Object)this.percent.get((Object)CharChoice.B0), ContentType.DISPLAY));
        this.descriptor.put(OPTION_CUSTOM_B1, new OptionDesc((Object)this.percent.get((Object)CharChoice.B1), ContentType.DISPLAY));
        this.descriptor.put(OPTION_CUSTOM_VTEC, new OptionDesc((Object)this.percent.get((Object)CharChoice.VTEC), ContentType.DISPLAY));
        this.descriptor.put(OPTION_CUSTOM_TAU, new OptionDesc((Object)this.percent.get((Object)CharChoice.TAU), ContentType.DISPLAY));
        this.descriptor.put(OPTION_DELTA_FOF2, new OptionDesc((Object)this.delta.get((Object)CharChoice.FOF2), ContentType.DISPLAY));
        this.descriptor.put(OPTION_DELTA_NMF2, new OptionDesc((Object)this.delta.get((Object)CharChoice.NMF2), ContentType.DISPLAY));
        this.descriptor.put(OPTION_DELTA_HMF2, new OptionDesc((Object)this.delta.get((Object)CharChoice.HMF2), ContentType.DISPLAY));
        this.descriptor.put(OPTION_DELTA_MUF3000, new OptionDesc((Object)this.delta.get((Object)CharChoice.MUF3000), ContentType.DISPLAY));
        this.descriptor.put(OPTION_DELTA_B0, new OptionDesc((Object)this.delta.get((Object)CharChoice.B0), ContentType.DISPLAY));
        this.descriptor.put(OPTION_DELTA_B1, new OptionDesc((Object)this.delta.get((Object)CharChoice.B1), ContentType.DISPLAY));
        this.descriptor.put(OPTION_DELTA_VTEC, new OptionDesc((Object)this.delta.get((Object)CharChoice.VTEC), ContentType.DISPLAY));
        this.descriptor.put(OPTION_DELTA_TAU, new OptionDesc((Object)this.delta.get((Object)CharChoice.TAU), ContentType.DISPLAY));
        this.descriptor.put(OPTION_PERCENT_FOF2, new OptionDesc((Object)this.percent.get((Object)CharChoice.FOF2), ContentType.DISPLAY));
        this.descriptor.put(OPTION_PERCENT_NMF2, new OptionDesc((Object)this.percent.get((Object)CharChoice.NMF2), ContentType.DISPLAY));
        this.descriptor.put(OPTION_PERCENT_HMF2, new OptionDesc((Object)this.percent.get((Object)CharChoice.HMF2), ContentType.DISPLAY));
        this.descriptor.put(OPTION_PERCENT_MUF3000, new OptionDesc((Object)this.percent.get((Object)CharChoice.MUF3000), ContentType.DISPLAY));
        this.descriptor.put(OPTION_PERCENT_B0, new OptionDesc((Object)this.percent.get((Object)CharChoice.B0), ContentType.DISPLAY));
        this.descriptor.put(OPTION_PERCENT_B1, new OptionDesc((Object)this.percent.get((Object)CharChoice.B1), ContentType.DISPLAY));
        this.descriptor.put(OPTION_PERCENT_VTEC, new OptionDesc((Object)this.percent.get((Object)CharChoice.VTEC), ContentType.DISPLAY));
        this.descriptor.put(OPTION_PERCENT_TAU, new OptionDesc((Object)this.percent.get((Object)CharChoice.TAU), ContentType.DISPLAY));
        this.descriptor.put(OPTION_COLORSCALE_ADJUST, new OptionDesc((Object)this.adjust, ContentType.DISPLAY));
    }

    @Override
    public GambitColorscaleSettings getThis() {
        return this;
    }

    @Override
    public String getName() {
        return SECTION_NAME;
    }

    @Override
    public Map<String, OptionDesc> getOptionsDescriptor() {
        return this.descriptor;
    }

    @Override
    public void getFrom(OptionsIO paramsIO) {
        this.custom.put(CharChoice.FOF2, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_CUSTOM_FOF2)));
        this.custom.put(CharChoice.NMF2, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_CUSTOM_NMF2)));
        this.custom.put(CharChoice.HMF2, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_CUSTOM_HMF2)));
        this.custom.put(CharChoice.MUF3000, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_CUSTOM_MUF3000)));
        this.custom.put(CharChoice.B0, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_CUSTOM_B0)));
        this.custom.put(CharChoice.B1, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_CUSTOM_B1)));
        this.custom.put(CharChoice.VTEC, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_CUSTOM_VTEC)));
        this.custom.put(CharChoice.TAU, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_CUSTOM_TAU)));
        this.delta.put(CharChoice.FOF2, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_DELTA_FOF2)));
        this.delta.put(CharChoice.NMF2, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_DELTA_NMF2)));
        this.delta.put(CharChoice.HMF2, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_DELTA_HMF2)));
        this.delta.put(CharChoice.MUF3000, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_DELTA_MUF3000)));
        this.delta.put(CharChoice.B0, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_DELTA_B0)));
        this.delta.put(CharChoice.B1, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_DELTA_B1)));
        this.delta.put(CharChoice.VTEC, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_DELTA_VTEC)));
        this.delta.put(CharChoice.TAU, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_DELTA_TAU)));
        this.percent.put(CharChoice.FOF2, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_PERCENT_FOF2)));
        this.percent.put(CharChoice.NMF2, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_PERCENT_NMF2)));
        this.percent.put(CharChoice.HMF2, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_PERCENT_HMF2)));
        this.percent.put(CharChoice.MUF3000, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_PERCENT_MUF3000)));
        this.percent.put(CharChoice.B0, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_PERCENT_B0)));
        this.percent.put(CharChoice.B1, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_PERCENT_B1)));
        this.percent.put(CharChoice.VTEC, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_PERCENT_VTEC)));
        this.percent.put(CharChoice.TAU, this.parseDuplet(paramsIO.get(SECTION_NAME, OPTION_PERCENT_TAU)));
        this.adjust = Double.parseDouble(paramsIO.get(SECTION_NAME, OPTION_COLORSCALE_ADJUST));
    }

    private double[] parseDuplet(String str) {
        String[] tokens = str.split(",");
        return new double[]{Double.parseDouble(tokens[0]), Double.parseDouble(tokens[1])};
    }

    @Override
    public void putTo(OptionsIO paramsIO) {
        paramsIO.put(SECTION_NAME, OPTION_CUSTOM_FOF2, this.formatDuplet(this.custom.get((Object)CharChoice.FOF2)));
        paramsIO.put(SECTION_NAME, OPTION_CUSTOM_NMF2, this.formatDuplet(this.custom.get((Object)CharChoice.NMF2)));
        paramsIO.put(SECTION_NAME, OPTION_CUSTOM_HMF2, this.formatDuplet(this.custom.get((Object)CharChoice.HMF2)));
        paramsIO.put(SECTION_NAME, OPTION_CUSTOM_MUF3000, this.formatDuplet(this.custom.get((Object)CharChoice.MUF3000)));
        paramsIO.put(SECTION_NAME, OPTION_CUSTOM_B0, this.formatDuplet(this.custom.get((Object)CharChoice.B0)));
        paramsIO.put(SECTION_NAME, OPTION_CUSTOM_B1, this.formatDuplet(this.custom.get((Object)CharChoice.B1)));
        paramsIO.put(SECTION_NAME, OPTION_CUSTOM_VTEC, this.formatDuplet(this.custom.get((Object)CharChoice.VTEC)));
        paramsIO.put(SECTION_NAME, OPTION_CUSTOM_TAU, this.formatDuplet(this.custom.get((Object)CharChoice.TAU)));
        paramsIO.put(SECTION_NAME, OPTION_DELTA_FOF2, this.formatDuplet(this.delta.get((Object)CharChoice.FOF2)));
        paramsIO.put(SECTION_NAME, OPTION_DELTA_NMF2, this.formatDuplet(this.delta.get((Object)CharChoice.NMF2)));
        paramsIO.put(SECTION_NAME, OPTION_DELTA_HMF2, this.formatDuplet(this.delta.get((Object)CharChoice.HMF2)));
        paramsIO.put(SECTION_NAME, OPTION_DELTA_MUF3000, this.formatDuplet(this.delta.get((Object)CharChoice.MUF3000)));
        paramsIO.put(SECTION_NAME, OPTION_DELTA_B0, this.formatDuplet(this.delta.get((Object)CharChoice.B0)));
        paramsIO.put(SECTION_NAME, OPTION_DELTA_B1, this.formatDuplet(this.delta.get((Object)CharChoice.B1)));
        paramsIO.put(SECTION_NAME, OPTION_DELTA_VTEC, this.formatDuplet(this.delta.get((Object)CharChoice.VTEC)));
        paramsIO.put(SECTION_NAME, OPTION_DELTA_TAU, this.formatDuplet(this.delta.get((Object)CharChoice.TAU)));
        paramsIO.put(SECTION_NAME, OPTION_PERCENT_FOF2, this.formatDuplet(this.percent.get((Object)CharChoice.FOF2)));
        paramsIO.put(SECTION_NAME, OPTION_PERCENT_NMF2, this.formatDuplet(this.percent.get((Object)CharChoice.NMF2)));
        paramsIO.put(SECTION_NAME, OPTION_PERCENT_HMF2, this.formatDuplet(this.percent.get((Object)CharChoice.HMF2)));
        paramsIO.put(SECTION_NAME, OPTION_PERCENT_MUF3000, this.formatDuplet(this.percent.get((Object)CharChoice.MUF3000)));
        paramsIO.put(SECTION_NAME, OPTION_PERCENT_B0, this.formatDuplet(this.percent.get((Object)CharChoice.B0)));
        paramsIO.put(SECTION_NAME, OPTION_PERCENT_B1, this.formatDuplet(this.percent.get((Object)CharChoice.B1)));
        paramsIO.put(SECTION_NAME, OPTION_PERCENT_VTEC, this.formatDuplet(this.percent.get((Object)CharChoice.VTEC)));
        paramsIO.put(SECTION_NAME, OPTION_PERCENT_TAU, this.formatDuplet(this.percent.get((Object)CharChoice.TAU)));
        paramsIO.put(SECTION_NAME, OPTION_COLORSCALE_ADJUST, String.valueOf(this.adjust));
    }

    private String formatDuplet(double[] values) {
        return String.valueOf(FC.doubleToString(values[0], 1, false)) + "," + FC.doubleToString(values[1], 1, false);
    }

    public double[] getCustomMinMax(CharChoice cc) {
        return this.custom.get((Object)cc);
    }

    public double[] getDeltaMinMax(CharChoice cc) {
        return this.delta.get((Object)cc);
    }

    public double[] getPercentMinMax(CharChoice cc) {
        return this.percent.get((Object)cc);
    }
}

