/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.lgdc.geospace.Geopack;
import edu.uml.lgdc.time.TimeScale;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.render.SurfaceShape;

public class SolarTerminator {
    public static final String LAYER_NAME = "Solar terminator";
    public static final double TERMINATOR_RADIUS = 1.0001965E7;
    public static final double SUBSOLAR_RADIUS = 300000.0;
    public static final double TERMINATOR_OPACITY = 0.3;
    public static final double NIGHT_SIDE_OPACITY = 0.15;
    public static final double SUBSOLAR_POINT_OPACITY = 0.5;
    public static final int DRAW_LINE = 0;
    public static final int DRAW_SHADOW = 1;

    public static LatLon getSubSolarPoint(TimeScale time) {
        Geopack geopack = new Geopack();
        geopack.recalc(time);
        double[] cartPosition = new double[]{0.0, 0.0, 0.0};
        double[] gsmPosition = new double[]{1.0, 0.0, 0.0};
        double[] sphericalPosition = new double[]{0.0, 0.0, 0.0};
        geopack.GsmToGeo(gsmPosition, cartPosition);
        Geopack.cartToSpher(cartPosition, sphericalPosition);
        sphericalPosition[0] = -(sphericalPosition[0] - 1.5707963267948966);
        if (sphericalPosition[1] > Math.PI) {
            sphericalPosition[1] = sphericalPosition[1] - Math.PI * 2;
        }
        LatLon subSolarPoint = LatLon.fromRadians((double)sphericalPosition[0], (double)sphericalPosition[1]);
        return subSolarPoint;
    }

    public static void configureSolarTerminatorLayer(RenderableLayer layer, TimeScale time, int drawType) {
        LatLon subsolarPointLatLon = SolarTerminator.getSubSolarPoint(time);
        LatLon antiSubsolarPointLatLon = LatLon.fromRadians((double)(-subsolarPointLatLon.latitude.radians), (double)(subsolarPointLatLon.longitude.radians - Math.signum(subsolarPointLatLon.longitude.degrees) * Math.PI));
        SurfaceCircle subsolarPoint = new SurfaceCircle(subsolarPointLatLon, 300000.0);
        subsolarPoint.setAttributes(SolarTerminator.getAttributesSubSolarPoint());
        subsolarPoint.setHighlightAttributes(SolarTerminator.getAttributesSubSolarPoint());
        SurfaceShape[] rays = SolarTerminator.getStarRays(subsolarPointLatLon, 300000.0);
        layer.removeAllRenderables();
        layer.addRenderable((Renderable)subsolarPoint);
        int iRay = 0;
        while (iRay < rays.length) {
            layer.addRenderable((Renderable)rays[iRay]);
            ++iRay;
        }
        SurfaceCircle terminator = new SurfaceCircle(antiSubsolarPointLatLon, 1.0001965E7);
        terminator.setAttributes(drawType == 1 ? SolarTerminator.getAttributesShadedTerminator() : SolarTerminator.getAttributesTerminator());
        terminator.setHighlightAttributes(drawType == 1 ? SolarTerminator.getAttributesShadedTerminator() : SolarTerminator.getAttributesTerminator());
        layer.addRenderable((Renderable)terminator);
    }

    private static SurfaceShape[] getStarRays(LatLon centerPosition, double centerRadius) {
        double thickMajorRadius = 0.5 * centerRadius;
        double thinMajorRadius = 0.3333333333333333 * centerRadius;
        double thickMinorRadius = 0.2 * centerRadius;
        double thinMinorRadius = 0.1 * centerRadius;
        double rayCenteresRadiusRadians = 0.09422926355740475;
        int numberOfRays = 8;
        double azimuthStep = 0.7853981633974483;
        SurfaceShape[] starRays = new SurfaceShape[8];
        int iRay = 0;
        while (iRay < 8) {
            LatLon rayCenter = LatLon.greatCircleEndPosition((LatLon)centerPosition, (double)((double)iRay * 0.7853981633974483), (double)rayCenteresRadiusRadians);
            Angle heading = Angle.fromRadians((double)((double)iRay * 0.7853981633974483 + 1.5707963267948966));
            starRays[iRay] = iRay % 2 == 0 ? new SurfaceEllipse(rayCenter, thickMajorRadius, thickMinorRadius, heading) : new SurfaceEllipse(rayCenter, thinMajorRadius, thinMinorRadius, heading);
            starRays[iRay].setAttributes(SolarTerminator.getAttributesSubSolarPoint());
            starRays[iRay].setHighlightAttributes(SolarTerminator.getAttributesSubSolarPoint());
            ++iRay;
        }
        return starRays;
    }

    private static ShapeAttributes getAttributesTerminator() {
        BasicShapeAttributes attrs = new BasicShapeAttributes();
        attrs.setOutlineMaterial(Material.BLACK);
        attrs.setOutlineOpacity(0.3);
        attrs.setOutlineWidth(8.0);
        attrs.setDrawInterior(false);
        attrs.setEnableAntialiasing(true);
        return attrs;
    }

    private static ShapeAttributes getAttributesSubSolarPoint() {
        BasicShapeAttributes attrs = new BasicShapeAttributes();
        attrs.setOutlineMaterial(Material.WHITE);
        attrs.setOutlineOpacity(0.5);
        attrs.setInteriorOpacity(0.5);
        attrs.setOutlineWidth(8.0);
        attrs.setDrawInterior(true);
        attrs.setEnableAntialiasing(true);
        return attrs;
    }

    private static ShapeAttributes getAttributesShadedTerminator() {
        BasicShapeAttributes attrs = new BasicShapeAttributes();
        attrs.setOutlineMaterial(Material.BLACK);
        attrs.setInteriorMaterial(Material.BLACK);
        attrs.setInteriorOpacity(0.15);
        attrs.setOutlineOpacity(0.3);
        attrs.setOutlineWidth(8.0);
        attrs.setDrawInterior(true);
        attrs.setEnableAntialiasing(true);
        return attrs;
    }
}

